#ifndef MARS_MExtractTimeAndChargeDigitalFilterPeakSearch
#define MARS_MExtractTimeAndChargeDigitalFilterPeakSearch

#ifndef MARS_MExtractTimeAndChargeDigitalFilter
#include "MExtractTimeAndChargeDigitalFilter.h"
#endif

#ifndef MARS_MArrayF
#include "MArrayF.h"
#endif

#ifndef MARS_MArrayI
#include "MArrayI.h"
#endif

class TH1F;
class TH2F;
class MPedestalPix;
class MExtractTimeAndChargeDigitalFilterPeakSearch : public MExtractTimeAndChargeDigitalFilter
{
private:

  static const Byte_t fgHiGainFirst;             //! Default for fHiGainFirst          (now set to: 0)
  static const Byte_t fgHiGainLast;              //! Default for fHiGainLast           (now set to:18)
  static const Byte_t fgLoGainFirst;             //! Default for fLoGainFirst          (now set to: 2)
  static const Byte_t fgLoGainLast;              //! Default for fLoGainLast           (now set to:14)
  static const Byte_t fgOffsetLeftFromPeak;      //! Default for fOffsetLeftFromPeak   (now set to: 1)  
  static const Byte_t fgOffsetRightFromPeak;     //! Default for fOffsetRightFromPeak  (now set to: 2)  
  static const Byte_t fgPeakSearchWindowSize;    //! Default for fPeakSearchWindowSize (now set to: 2)

  Byte_t  fOffsetLeftFromPeak;                   // Number of slices to start extraction before peak slice
  Byte_t  fOffsetRightFromPeak;                  // Number of slices to stop  extraction after  peak slice
  Byte_t  fPeakSearchWindowSize;                 // Size of FADC window in the search for the highest peak of all pixels.

  void    FindPeak(Byte_t *ptr, Byte_t &startslice, Int_t &signal, Int_t &sat, Byte_t &satpos) const;

  Int_t   ReadEnv(const TEnv &env, TString prefix, Bool_t print);
  Int_t   Process();

public:

  MExtractTimeAndChargeDigitalFilterPeakSearch(const char *name=NULL, const char *title=NULL);  
  ~MExtractTimeAndChargeDigitalFilterPeakSearch() { }
  
  void SetOffsetLeftFromPeak ( Byte_t offset=fgOffsetLeftFromPeak  )  {  fOffsetLeftFromPeak   = offset; }
  void SetOffsetRightFromPeak( Byte_t offset=fgOffsetRightFromPeak )  {  fOffsetRightFromPeak  = offset; }
  void SetPeakSearchWindowSize(Byte_t size =fgPeakSearchWindowSize )  {  fPeakSearchWindowSize = size;   }

  void Print(Option_t *o="") const;

  ClassDef(MExtractTimeAndChargeDigitalFilterPeakSearch, 1)   // Digital filter with global Peak Search
};

#endif
