#ifndef MARS_MSequence
#define MARS_MSequence

#ifndef ROOT_TArrayI
#include <TArrayI.h>
#endif

#ifndef MARS_MTime
#include "MTime.h"
#endif

class MDirIter;

class MSequence : public MParContainer
{
private:
    UInt_t fSequence;

    MTime  fStart;

    UInt_t fLastRun;
    UInt_t fNumEvents;

    UInt_t fPeriod;
    MTime  fNight;

    TString fProject;
    TString fSource;
    TString fTriggerTable;
    TString fHvSettings;

    TArrayI fRuns;
    TArrayI fCalRuns;
    TArrayI fPedRuns;
    TArrayI fDatRuns;

    void Split(TString &runs, TArrayI &data) const;
    Int_t SetupRuns(MDirIter &iter, const TArrayI &arr, const char *path, char *id, Bool_t raw=kFALSE) const;

public:
    MSequence() : fSequence((UInt_t)-1), fLastRun((UInt_t)-1),
        fNumEvents((UInt_t)-1), fPeriod((UInt_t)-1) { }
    MSequence(const char *fname);
    MSequence(const MSequence &s) : fSequence(s.fSequence), fStart(s.fStart),
        fLastRun(s.fLastRun), fNumEvents(s.fNumEvents), fPeriod(s.fPeriod),
        fNight(s.fNight), fProject(s.fProject), fSource(s.fSource),
        fTriggerTable(s.fTriggerTable), fHvSettings(s.fHvSettings),
        fRuns(s.fRuns), fCalRuns(s.fCalRuns), fPedRuns(s.fPedRuns),
        fDatRuns(s.fDatRuns) { }

    void Print(Option_t *o="") const;

    Bool_t IsValid() const { return fSequence!=(UInt_t)-1; }

    Int_t SetupPedRuns(MDirIter &iter, const char *path=0, char *id="P", Bool_t raw=kFALSE) const;
    Int_t SetupDatRuns(MDirIter &iter, const char *path=0, char *id="D", Bool_t raw=kFALSE) const;
    Int_t SetupAllRuns(MDirIter &iter, const char *path=0, char *id="?", Bool_t raw=kFALSE) const;
    Int_t SetupCalRuns(MDirIter &iter, const char *path=0, char *id="C", Bool_t raw=kFALSE) const;

    Int_t GetNumAllRuns() const { return fRuns.GetSize(); }
    Int_t GetNumDatRuns() const { return fDatRuns.GetSize(); }
    Int_t GetNumPedRuns() const { return fPedRuns.GetSize(); }
    Int_t GetNumCalRuns() const { return fCalRuns.GetSize(); }

    // Getter
    UInt_t GetSequence() const { return fSequence; }
    UInt_t GetLastRun() const  { return fLastRun; }
    UInt_t GetPeriod() const   { return fPeriod; }

    const UInt_t GetFirstRun() const { return fRuns[0]; }
    const UInt_t GetFirstCalRun() const { return fCalRuns[0]; }
    const UInt_t GetLastCalRun() const { return fCalRuns[fCalRuns.GetSize()-1]; }
    const MTime &GetStart() const { return fStart; }
    const MTime &GetNight() const { return fNight; }
    const TString &GetSource() const { return fSource; } 

    ClassDef(MSequence, 0)
};

#endif
