#ifndef MARS_MJob
#define MARS_MJob

#ifndef MARS_MSequence
#include "MSequence.h"
#endif

class TEnv;
class MEvtLoop;

class MJob : public MParContainer
{
private:
    void FixPath(TString &path) const;

    const TEnv *fEnv;         // Resource file
    TString     fEnvPrefix;   // Prefix for resources
    Bool_t      fEnvDebug;    // Debug setup of resources

    enum DataType_t {
      kIsUseRawData,
      kIsUseRootData,
      kIsUseMC
    };

protected:

    Byte_t    fDataFlag;      // Bit-field to store the data type
    TString   fPathOut;       // Directory to write output file to (eg. calib*.root)
    TString   fPathIn;        // Directory to read output from (eg. calib*.root)
    TString   fPathData;      // Directory to read  data files from (2004*.root)

    Bool_t    fOverwrite;     // Allow overwriting output files
    Int_t     fMaxEvents;     // Maximum number of events

    MSequence fSequence;      // Sequence

    Bool_t IsUseRawData()  const { return TESTBIT(fDataFlag,kIsUseRawData);  }
    Bool_t IsUseRootData() const { return TESTBIT(fDataFlag,kIsUseRootData); }
    Bool_t IsUseMC()       const { return TESTBIT(fDataFlag,kIsUseMC);       }

    void   SetUseRawData ( const Bool_t b=kTRUE )  { b ? SETBIT(fDataFlag,kIsUseRawData)  : CLRBIT(fDataFlag,kIsUseRawData);  }
    void   SetUseRootData( const Bool_t b=kTRUE )  { b ? SETBIT(fDataFlag,kIsUseRootData) : CLRBIT(fDataFlag,kIsUseRootData); }
    void   SetUseMC      ( const Bool_t b=kTRUE )  { b ? SETBIT(fDataFlag,kIsUseMC)       : CLRBIT(fDataFlag,kIsUseMC);       }

    const TEnv *GetEnv() const { return fEnv; }
    const TString &GetEnvPrefix() const { return fEnvPrefix; }
    Bool_t GetEnvDebug() const { return fEnvDebug; }

    Int_t       GetEnv(const char *name, Int_t dflt) const;
    Double_t    GetEnv(const char *name, Double_t dflt) const;
    const char *GetEnv(const char *name, const char *dflt) const;
    Bool_t      HasEnv(const char *name) const;

    Bool_t SetupEnv(MEvtLoop &loop) const;
    Bool_t CheckEnv();
    virtual Bool_t CheckEnvLocal() { return kTRUE; }

    Bool_t WriteContainer(TCollection &list) const;
    Bool_t ReadContainer(TCollection &list) const;
    Bool_t WriteContainer(TCollection &cont, const char *name, const char *option="RECREATE", const int compr=2) const;

public:
    MJob(const char *name=NULL, const char *title=NULL);
    ~MJob();

    // Setter
    void   SetPathOut(const char *path=".");
    void   SetPathIn(const char *path=".");
    void   SetPathData(const char *path=".");

    void   SetOverwrite(Bool_t b=kTRUE) { fOverwrite=b; }
    Bool_t SetEnv(const char *env, const char *prefix=0);
    void   SetEnvDebug(Bool_t b=kTRUE) { fEnvDebug=b; }

    void   SetMaxEvents(Int_t max) { fMaxEvents = max; }
    void   SetSequence(const MSequence &seq) { fSequence = seq; }

    // Getter
    TString GetPathOut() const  { return fPathOut; }
    TString GetPathIn() const   { return fPathIn; }
    TString GetPathData() const { return fPathData; }

    // Others
    MStatusDisplay *GetDisplay() { return fDisplay; }

    ClassDef(MJob, 0) // Bas class for Jobs
};

#endif
