#ifndef MARS_MJCalibTest
#define MARS_MJCalibTest

#ifndef MARS_MJob
#include "MJob.h"
#endif
#ifndef MARS_MJCalib
#include "MJCalib.h"
#endif
#ifndef MARS_MCalibrationTestCam
#include "MCalibrationTestCam.h"
#endif
#ifndef MARS_MHCalibrationTestTimeCam
#include "MHCalibrationTestTimeCam.h"
#endif
#ifndef MARS_MPedPhotCam
#include "MPedPhotCam.h"
#endif
#ifndef MARS_MBadPixelsCam
#include "MBadPixelsCam.h"
#endif

class MParList;
class MPedestalCam;
class MCalibrationRelTimeCam;
class MCalibrationChargeCam;
class MCalibrationQECam;
class MExtractor;
class MExtractTime;
class MJCalibTest : public MJob, public MJCalib
{
private:

  Bool_t  fUseCosmicsFilter;

  MExtractor   *fExtractor;                  // Signal extractor
  MExtractTime *fTimeExtractor;              // Arrival time extractor  
  
  MBadPixelsCam            fBadPixels;
  MCalibrationTestCam      fTestCam;
  MHCalibrationTestTimeCam fTestTimeCam;
  MPedPhotCam              fPedPhotCam;

  enum  Display_t                                      // Possible Display types
    {
      kDataCheckDisplay,
      kNormalDisplay
    };
  
  Display_t fDisplayType;                              // Chosen Display type

  TString fGeometry;
  
  Bool_t ReadPedPhotCam();
  
  void   DisplayResult(MParList &plist);
  void   DisplayResultT(MParList &plist);

  Bool_t WriteResult();
  
  Bool_t ProcessFile(MPedestalCam &pedcam, MCalibrationChargeCam &calcam, MCalibrationQECam &qecam, 
		     MCalibrationRelTimeCam &rel, Byte_t filetype);

public:

  MJCalibTest(const char *name=NULL, const char *title=NULL);
  
  const char* GetOutputFile() const;
  
  MCalibrationTestCam      &GetTestCam()      { return fTestCam; }
  MHCalibrationTestTimeCam &GetTestTimeCam()  { return fTestTimeCam; }  
  MPedPhotCam          &GetPedPhotCam() { return fPedPhotCam; }
  const MBadPixelsCam &GetBadPixels()  const { return fBadPixels; }
  
  void SetExtractor(MExtractor* ext)              { fExtractor = ext; }
  void SetTimeExtractor(MExtractTime* ext)         { fTimeExtractor = ext; }
  void SetBadPixels(const MBadPixelsCam &bad) { bad.Copy(fBadPixels); }
  void SetUseCosmicsFilter( const Bool_t b )    { fUseCosmicsFilter = b;  }

  // Displays
  void SetDataCheckDisplay() { fDisplayType = kDataCheckDisplay; }
  void SetNormalDisplay()    { fDisplayType = kNormalDisplay;    }
  
  Bool_t Process(MPedestalCam &pedcam, MCalibrationChargeCam &calcam, MCalibrationQECam &qecam, 
		 MCalibrationRelTimeCam &relcam,Byte_t filetype=1);
  
  ClassDef(MJCalibTest, 0) // Tool to calibrate and test the calibration run itself
};

#endif
