#ifndef MARS_MJCalib
#define MARS_MJCalib

#ifndef MARS_MJob
#include "MJob.h"
#endif

class MRunIter;

class MJCalib : public MJob
{
private:
    Byte_t    fDataFlag;      // Bit-field to store the data type

protected:

  MRunIter *fRuns;          // Data files, only used for test applications, default is sequence files!
  
  enum DataType_t
    {
      kIsUseRawData,
      kIsUseRootData,
      kIsUseMC
    };

  Bool_t IsUseRawData()  const { return fDataFlag==kIsUseRawData;  }
  Bool_t IsUseRootData() const { return fDataFlag==kIsUseRootData; }
  Bool_t IsUseMC()       const { return fDataFlag==kIsUseMC;       }
  
  void   SetUseRawData ( const Bool_t b=kTRUE )  { fDataFlag=kIsUseRawData;  }
  void   SetUseRootData( const Bool_t b=kTRUE )  { fDataFlag=kIsUseRootData; }
  void   SetUseMC      ( const Bool_t b=kTRUE )  { fDataFlag=kIsUseMC;       }

  Bool_t CheckEnvLocal();

public:

  MJCalib();
  
  void SetInput      ( MRunIter *iter       )  { fRuns = iter; }
  
  ClassDef(MJCalib, 0) // Base class for calibration jobs
};

#endif
