#ifndef MARS_MEffAreaAndCoeffCalc
#define MARS_MEffAreaAndCoeffCalc

#ifndef MARS_MTask
#include "MTask.h"
#endif

class TF1;
class TH1D;
class MHillas;
class MMcEvt;

#include "TChain.h"

class MEffAreaAndCoeffCalc
{
 private:

  TF1* fSpec;        // function used to parametrized the spectrum
  TH1D* fHorig;      // histogram with the original energy spectrum

  Int_t fEbins;      // number of bins to build spectrum
  Int_t fEsubbins;   // number of subbins per big bin
  Double_t fEmin;    // Minimum energy in GeV
  Double_t fEmax;    // Maximum energy in GeV

  
  Double_t* fWeight; // array containing weights
  Double_t* fCoeff;  // array containing coefficients
  Double_t* fEffA;   // array containing effective areas

  TChain* fCini; // chain for initial MC events (even those not triggering)
  TChain* fCcut; // chain for surviving MC events (after cuts)

  MHillas* fHillas; // pointer to the MHillas Branch
  MMcEvt*  fMcEvt;   // pointer to the MMcEvt Branch

 protected:
  void FillOriginalSpectrum();
  void ComputeCoefficients();
  void ComputeWeights();
  void ComputeEffectiveAreas();

 public:
  MEffAreaAndCoeffCalc();

  virtual ~MEffAreaAndCoeffCalc();

  void SetFunction(const Char_t* chfunc, Float_t emin=0., Float_t emax=0.);
  void SetFunction(TF1*);
  void SetEbins(Int_t i)    {fEbins=i;}
  void SetEsubbins(Int_t i) {fEsubbins=i;}
  void SetE(Float_t x)        {fEmin=x;}
  void SetEbins(Float_t x)    {fEmax=x;}

  void AddFileToInitialMC(const Char_t* name) {fCini->Add(name);}
  void AddFileToFinalMC(const Char_t* name) {fCcut->Add(name);}

  Double_t GetEffectiveArea(Int_t i) {return fEffA[i];}
  Double_t GetCoefficient(Int_t i)   {return fCoeff[i];}

  void ComputeAllFactors();

  ClassDef(MEffAreaAndCoeffCalc, 0) // task to compute the Effective areas and Coefficients for the unfolding 
};

#endif

