#ifndef MARS_MJCalib
#define MARS_MJCalib

#ifndef MARS_MJob
#include "MJob.h"
#endif

class MRunIter;

class MJCalib : public MJob
{
public:
    enum DataType_t
    {
        kIsUseRootData,
        kIsUseRawData,
        kIsUseMC
    };

private:
    Byte_t fDataFlag;      // Bit-field to store the data type

protected:
    MRunIter *fRuns;          // Data files, only used for test applications, default is sequence files!

    Bool_t CheckEnvLocal();

public:
    MJCalib();

    void SetInput(MRunIter *iter) { fRuns = iter; }

    Byte_t GetDataFlag() const { return fDataFlag; }

    Bool_t IsUseRawData()  const { return fDataFlag==kIsUseRawData;  }
    Bool_t IsUseRootData() const { return fDataFlag==kIsUseRootData; }
    Bool_t IsUseMC()       const { return fDataFlag==kIsUseMC;       }

    void SetUseRawData () { fDataFlag=kIsUseRawData;  }
    void SetUseRootData() { fDataFlag=kIsUseRootData; }
    void SetUseMC      () { fDataFlag=kIsUseMC;       }

    void SetDataType(DataType_t type) { fDataFlag=type; }
  
    ClassDef(MJCalib, 0) // Base class for calibration jobs
};

#endif
