#ifndef MARS_MJCalib
#define MARS_MJCalib

#ifndef MARS_MJob
#include "MJob.h"
#endif

class MRunIter;

class MJCalib : public MJob
{
public:
    enum DataType_t
    {
        kIsUseRootData,
        kIsUseRawData,
        kIsUseMC
    };

private:

    static const Int_t fgCheckedPixId;  //! Default for fCheckedPixId

    Byte_t fDataFlag;                    // Bit-field to store the data type

protected:

    Bool_t fPixelCheck;                  // Check a test pixel?
    Int_t  fCheckedPixId;                // ID of checked pixel

    MRunIter *fRuns;                     // Data files, only used for test applications, default is sequence files!

    Bool_t CheckEnvLocal();

public:
    MJCalib();

    void SetInput(MRunIter *iter) { fRuns = iter; }

    Bool_t IsUseRawData()  const { return fDataFlag==kIsUseRawData;  }
    Bool_t IsUseRootData() const { return fDataFlag==kIsUseRootData; }
    Bool_t IsUseMC()       const { return fDataFlag==kIsUseMC;       }

    void SetUseRawData () { fDataFlag=kIsUseRawData;  }
    void SetUseRootData() { fDataFlag=kIsUseRootData; }
    void SetUseMC      () { fDataFlag=kIsUseMC;       }

    void SetDataType(DataType_t type) { fDataFlag=type; }
  
    void SetPixelCheck  ( const Bool_t b=kTRUE )         { fPixelCheck   = b; }
    void SetCheckedPixId( const Int_t i=fgCheckedPixId ) { fCheckedPixId = i; }

    ClassDef(MJCalib, 0) // Base class for calibration jobs
};

#endif
