/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MParList                                                                //
//                                                                         //
// This class contains a list of different parameter containers.           //
//                                                                         //
// A parameter container is an object which is derived from                //
// MParContainer.                                                          //
//                                                                         //
// Normally a parameter container is used for data exchange between two    //
// tasks at runtime.                                                       //
//                                                                         //
// You can add every parameter container (Named object) to the             //
// instance and access it from somewhere else via its Name.                //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
#include "MParList.h"

#include <TNamed.h>

#include "MLog.h"

ClassImp(MParList)

MParList::MParList()
{
  //
  //  default constructor 
  //  creates an empty list 
  //

}

MParList::MParList(MParList &ts)
{
  //
  // copy constructor 
  //

  fContainer.AddAll(&ts.fContainer);
}

void MParList::SetLogStream(MLog *log)
{
    //
    //  create the Iterator over the tasklist
    //
    TIter Next(&fContainer);

    MParContainer *cont=NULL;

    //
    // loop over all tasks for preproccesing
    //
    while ( (cont=(MParContainer*)Next()) )
        cont->SetLogStream(log);

    MParContainer::SetLogStream(log);
}

Bool_t MParList::AddToList(MParContainer *obj, MParContainer *where)
{
  // 
  //  Add an Container to the list.
  // 
  //  If 'where' is given, the object will be added after this.
  //
  
  //
  //  check if the object (you want to add) exists
  //

  if (!obj) return kTRUE;

  *fLog << "Adding " << obj->GetName() << " to " << GetName() << "... " << flush;
  //
  //  check if it is in the list yet
  //
  if (fContainer.FindObject(obj))
  {
      *fLog << "WARNING: MParList::add: Container already added" << endl;
      return kTRUE;
  }

  //
  //  check if you want to add the new parameter container somewhere 
  //  special (in that case you specify "where") 
  //  
  if (where)
  {
      if (!fContainer.FindObject(where))
      {
          *fLog << "ERROR: MParList::add: Cannot find parameter container after which the new one should be added!" << endl;
          return kFALSE;
      }
  }

  fContainer.Add(obj);
  *fLog << "Done." << endl;

  return kTRUE;
}

MParContainer *MParList::FindObject(const char *name) const
{
    //
    //  Find an object in the list.
    //  'name' is the name of the object you are searching for.
    //
    return (MParContainer*)fContainer.FindObject(name);
}


void MParList::Print(Option_t *t)
{
  //
  //   print some information about the current status of MParList
  //
  *fLog << "ParList: " << this->GetName() << " <" << this->GetTitle() << ">" << endl;
  *fLog << endl;
  
}

