#ifndef MCAMDISPLAY_H
#define MCAMDISPLAY_H

#ifndef MAGIC_H
#include "MAGIC.h"
#endif
#ifndef MHEXAGON_H
#include "MHexagon.h"
#endif
#ifndef MCERPHOTPIX_H
#include "MCerPhotPix.h"
#endif
#ifndef MCERPHOTEVT_H
#include "MCerPhotEvt.h"
#endif
#ifndef ROOT_TClonesArray
#include <TClonesArray.h>
#endif

class TClonesArray ;
class MCerPhotEvt  ;
class TBox;
class TText;

class MCamDisplay : public TObject
{
 private: 
  Bool_t        fAutoScale ;   //!  indicating the autoscale function
  
  Int_t         fNbPixels ;    //!
  TClonesArray  *fPixels   ;   //!

  Float_t       fMinPhe ;      //!  The minimal number of Phe
  Float_t       fMaxPhe ;      //!  The maximum number of Phe

  TClonesArray  *fLegend  ;    //! 
  TClonesArray  *fLegText ;    //! 

  TBox *GetBox(Int_t i)   { return (TBox*) fLegend->At(i); }
  TText *GetText(Int_t i) { return (TText*)fLegText->At(i); }

  void SetPixColor(MCerPhotPix &pix)
  {
      (*this)[pix.GetPixId()].SetFillColor( GetColor(pix.GetNumPhotons()));
  }

 public:
  
  MCamDisplay ( Int_t type=0 ) ; 

  ~MCamDisplay () ; 

  void Init() ;

  void Draw(Option_t *option = "" ) ; 

  void DrawPhotNum( MCerPhotEvt *event) ;
  void DrawPhotErr( MCerPhotEvt *event) ;

  void Reset() ; 

  MHexagon &operator[](int i) { return *((MHexagon*)fPixels->At(i)); }

  Int_t GetColor( Float_t wert ) ; 

  void UpdateLegend() ;  

  void SetAutoScale (Bool_t input = kTRUE ) 
    { 
      fAutoScale = input ; 
    } 

  ClassDef(MCamDisplay, 1) // Display the magic camera
};

#endif
