#include "MFillAdcSpect.h"

#include <iostream.h>

#include "MParList.h"
#include "MHistosAdc.h"
#include "MRawEvtData.h"
#include "MRawEvtPixelIter.h"

//ClassImp(MFillAdcSpect)

MFillAdcSpect::MFillAdcSpect (const char *name, const char *title)
{
  *fName  = name  ? name  : "MFillAdcSpect";
  *fTitle = title ? title : "Task to fill the adc spectra with  raw data";
  
  fRawEvtData   = NULL ; 
  fPixelIter    = NULL ; 
}



Bool_t MFillAdcSpect::PreProcess (MParList *pList)
{
  // connect the raw data with this task
  
  fHistos = (MHistosAdc*)pList->FindObject("MHistosAdc");
  if (!fHistos) 
    {
        cout << "MRawFileRead::PreProcess - WARNING: MHistosAdc not found... creating." << endl;
        fHistos = new MHistosAdc;
        pList->AddToList(fHistos);
    }

  fRawEvtData = (MRawEvtData*)pList->FindObject("MRawEvtData");
  if (!fRawEvtData)
    {
        cout << "MRawFileRead::PreProcess - WARNING: MRawEvtData not found... exit." << endl;
        return kFALSE;
    }

  fPixelIter = new MRawEvtPixelIter( fRawEvtData );

  return kTRUE ; 

} 

    
Bool_t MFillAdcSpect::Process()
{
  //  loop over the pixels and fill the values in the histograms
  
  fPixelIter->Reset() ; 

  const Int_t nhisamples = fRawEvtData->GetNumHiGainSamples() ;
  const Int_t nlosamples = fRawEvtData->GetNumLoGainSamples() ;

  //  cout << "HighSamples " << iHighSamples ;

  while ( fPixelIter->Next() )
    { 
      for (Int_t i=0 ; i<nhisamples ; i++ )
	{ 
	  fHistos->FillAdcHistHi ( fPixelIter->GetPixelId(),
				     fPixelIter->GetHiGainFadcSamples()[i] );
	}

      for (Int_t i=0 ; i<nlosamples ; i++ )
	{ 
	  fHistos->FillAdcHistLo ( fPixelIter->GetPixelId(),
				    fPixelIter->GetLoGainFadcSamples()[i] );
	}
    } 
  
  return kTRUE;
  
} 
