#include "MDumpEvtHeader.h"

#include "MLog.h"
#include "MLogManip.h"
#include "MParList.h"
#include "MRawEvtHeader.h"
#include "MRawEvtPixelIter.h"

ClassImp(MDumpEvtHeader)

Bool_t MDumpEvtHeader::PreProcess (MParList *pList)
{
    fRawEvtHeader = (MRawEvtHeader*)pList->FindObject("MRawEvtHeader");
    if (!fRawEvtHeader)
    {
        *fLog << dbginf << " Error: MRawEvtHeader not found... exit." << endl;
        return kFALSE ;
    }

    fRawEvtData = (MRawEvtData*)pList->FindObject("MRawEvtData");
    if (!fRawEvtData)
    {
        *fLog << dbginf << " Error: MRawEvtData not found... exit." << endl;
        return kFALSE ;
    }

    return kTRUE ;
} 

Bool_t MDumpEvtHeader::Process()
{
  fRawEvtHeader->Print() ; 

  MRawEvtPixelIter pixel( fRawEvtData );

  while ( pixel.Next() )
  {
      *fLog << " " << pixel.GetPixelId() ;
  }

  *fLog << endl ;
  
  return kTRUE;
} 
