#include "MShowSpect.h"

#include "MLog.h"
#include "MLogManip.h"
#include "MParList.h"      // MParList
#include "MGDisplayAdc.h"  // MGDisplayAdc


////////////////////////////////////////////////////////////////////////
//
//  MGShowSpect.h
//
//  A Gui Task to show the raw ADC values in the histograms
//

ClassImp(MShowSpect)

MShowSpect::MShowSpect(char *nameHist ) 
{ 
  // default constructor 

  sprintf (fHistName, "%s", nameHist ) ; 
} 


Bool_t MShowSpect::PreProcess(MParList *pList)
{
  //
  //   Do the preprocessing for MShowSpect
  // 
  //   Connects Histogramms in the MHistosAdc container as the input
  //

  fHists = (MHistosAdc*) pList->FindObject( fHistName );
  
  if (!fHists)
    {
        *fLog << dbginf << " Error: MHistosAdc '" << fHistName << "' not found!" << endl;
        return kFALSE;
    }
  
  return kTRUE;
} 


Bool_t MShowSpect::PostProcess()
{
  //   just start the gui for displaying the adc spectra

  new MGDisplayAdc(fHists, gClient->GetRoot(), gClient->GetRoot(), 600, 600);

  return kTRUE;
} 










