///////////////////////////////////////////////////////////////////////
//
// MHistosAdc
//
// This class contains a list of all ADC spektra histograms
//
///////////////////////////////////////////////////////////////////////

#include "MHistosAdc.h"

#include <iostream.h>

#include <TH1.h>
#include <TFile.h>

ClassImp(MHistosAdc)

MHistosAdc::MHistosAdc (const char *name, const char *title)
{
    //
    //  default constructor
    //  creates an a list of histograms for all pixels and both gain channels
    //

    //
    //   set the name and title of this object
    //
    
    *fName  = name  ? name  : "MHistosAdc" ;
    *fTitle = title ? title : "Container for ADC spectra histograms" ;

    //
    //   loop over all Pixels and create two histograms
    //   one for the Low and one for the High gain
    //   connect all the histogram with the container fHist
    //
    fHistHi = new TObjArray(577);
    fHistLo = new TObjArray(577);

    Char_t  tmp1[40];
    Char_t  tmp2[40];

    for ( Int_t i = 0 ; i < 577 ; i++)
    {
        sprintf ( tmp1, "high%d", i ) ;
        sprintf ( tmp2, "high gain Pixel %d", i ) ;

        fHistHi->Add( new TH1F ( tmp1, tmp2, 256, 0., 255. )  ) ;

        sprintf ( tmp1, "low %d", i ) ;
        sprintf ( tmp2, "low gain Pixel %d", i ) ;

        fHistLo->Add( new TH1F ( tmp1, tmp2, 256, 0., 255. ) ) ;
    }
}

MHistosAdc::~MHistosAdc ()
{
  
  //   default destructor 
  //
  delete fHistHi ;
  delete fHistLo ;
}

void MHistosAdc::Print(Option_t *)
{
  for ( Int_t i = 0 ; i < 576 ; i++)
    {
      fHistHi[i].Print() ;
    }
}

void MHistosAdc::FillAdcHistHi ( Int_t iPix, Byte_t data)
{
  //
  
  GetHistHi(iPix)->Fill( (Float_t) data ) ;
}

void MHistosAdc::FillAdcHistLo ( Int_t iPix, Byte_t data)
{
  //
  
  GetHistLo(iPix)->Fill( (Float_t) data ) ;
}

void MHistosAdc::SaveHist ( char *name )
{
    //
    //   save all histogram in this class to a root file
    //

    //
    // FIXME: Don't open a file and write to this file!
    // just Fill the current container (or the two histograms
    // to an open file. The user must choose a file before.
    //
    TFile out( name, "recreate") ;

    //
    //  loop over all pixels and write the files out
    //

    fHistLo->Write() ;
    fHistHi->Write() ;
}

