#include "MCeCoCom.h"

#include <iostream>

#include "MString.h"

using namespace std;

bool MCeCoCom::InterpreteCmd(TString cmd, TString str)
{
    cout << cmd << ": " << str << endl;
    return true;
}

bool MCeCoCom::InterpreteReport(TString &str)
{
    int y, m, d, h, min, s, ms, len;

    int n=sscanf(str.Data(),
                 "%02d %04d %02d %02d %02d %02d %02d %03d %n",
                 &fCCStatus, &y, &m, &d, &h, &min, &s, &ms, &len);
    if (n!=8)
    {
        cout << "Communication Problem: Wrong number of arguments" << endl;
        fComStat = kComProblem;
        return false;
    }
    str.Remove(0, len);

    fT.Set(y, m, d, h, min, s, ms);

    // Remove the 30 tokens of the subsystem status
    //  table 12.1 p59
    for (int i=0; i<31; i++)
        str.Remove(0, str.First(' ')+1);

    // skip solar_irr_Wm2, wind_speed, UPS
    float zd, az, dec, ra, temp, solar, wind, hum;
    n=sscanf(str.Data(),
             /*"%f %f %f %f %f %f %f %f %*f %*f %*s %*s %*s %*s %n"*/,
             "%f %f %f %f %f %f %f %f %*f %*f %n",
             &zd, &az, &dec, &ra, &temp, &solar, &wind, &hum, &len);
    if (n!=8)
    {
        cout << "Communication Problem: Wrong number of arguments" << endl;
        fComStat = kComProblem;
        return false;
    }
    str.Remove(0, len);

    if (str!=(TString)"OVER")
    {
        cout << "Communication Problem: Termination (OVER) too far away." << endl;
        fComStat = kComProblem;
        return false;
    }

    fHumidity = hum;
    fTemperature = temp;
    fSolarRadiation = solar;
    fWindSpeed = wind;

    if (fWindSpeed>50)
        fAlarmCounter++;
    else
        fAlarmCounter=0;

    cout << "Zd/Az: " << zd << "/" << az << "  ";
    cout << "Ra/Dec: " << ra/15 << "h/" << dec << "  ";
    cout << "SolRad: " << solar << "W/m" << endl;

    fComStat = kCmdReceived;
    return true;
}

bool MCeCoCom::InterpreteStr(TString str)
{
    const Ssiz_t tok  = str.First(' ');
    const TString cmd = tok<0 ? str : str(0, tok);
    if (tok<0)
        str = "";
    else
        str.Remove(0, tok+1);

    if (cmd==(TString)"CC-REPORT" && str.EndsWith("OVER"))
        return InterpreteReport(str);

    const bool rc = InterpreteCmd(cmd, str.Strip(TString::kBoth));
    fComStat = rc ? kCmdReceived : kComProblem;
    return rc;
}

bool MCeCoCom::Send(const char *cmd, const char *str, bool force=kFALSE)
{
    MTime t;
    t.Now();

    UShort_t y1, y2, ms1, ms2;
    Byte_t mon1, mon2, d1, d2, h1, h2, m1, m2, s1, s2;

    t.GetDate(y1, mon1, d1);
    t.GetTime(h1, m1, s1, ms1);

    fT.GetDate(y2, mon2, d2);
    fT.GetTime(h2, m2, s2, ms2);

    MString msg;
    msg.Print("%s "
             "%02d %04d %02d %02d %02d %02d %02d %03d "
             "%02d %04d %02d %02d %02d %02d %02d %03d "
             "%s\n", cmd,
             fStatus,  y1, mon1, d1, h1, m1, s1, ms1,
             fComStat, y2, mon2, d2, h2, m2, s2, ms2,
             str);

    const bool rc = MTcpIpIO::Send(msg, force);
    fComStat = rc ? kNoCmdReceived : kComProblem;
    return rc;
}

TString MCeCoCom::GetWeather() const
{
    if (fSolarRadiation<0 || (double)MTime(-1)-(double)fT>11)
        return "";

    MString str;
    return str.Print("Temp: %.1f'C  Hum: %.1f%%  Wind: %.1fkm/h",
                     fTemperature, fHumidity, fWindSpeed);
}

Int_t MCeCoCom::GetWeatherStatus() const
{
    if (fSolarRadiation<0 || (double)MTime(-1)-(double)fT>11)
        return 0;

    Int_t rc = 0;
    if (fHumidity>80)
        rc++;
    if (fWindSpeed>30)
        rc++;
    if (fWindSpeed>40)
        rc++;
    if (fWindSpeed>50)
        rc++;

    return rc;
}
