#ifndef MARS_MHCamEvent
#define MARS_MHCamEvent

#ifndef MARS_MH
#include "MH.h"
#endif

class MHCamera;
class MCamEvent;

class MHCamEvent : public MH
{
private:
    static const TString gsDefName;
    static const TString gsDefTitle;

protected:
    MHCamera  *fSum;       // storing the sum
    MCamEvent *fEvt;       //! the current event

    TString fNameEvt;      // Name of MCamEvent to fill into histogram
    TString fNameGeom;     // Name of geometry container

    Int_t fType;           // Type to used for calling GetPixelContent

    Float_t fThreshold;    // Count pixel above/below this threshold
    Char_t fUseThreshold;  // Use a threshold? Which direction has it?

    void Init(const char *name, const char *title);

    Bool_t SetupFill(const MParList *pList);
    Bool_t Fill(const MParContainer *par, const Stat_t w=1);

public:
    enum { kIsLowerBound=1, kIsUpperBound=-1, kNoBound=0 };

    MHCamEvent(const char *name=NULL, const char *title=NULL);
    MHCamEvent(Int_t type, const char *name=NULL, const char *title=NULL);
    ~MHCamEvent();

    void SetNameEvt(const TString name)  { fNameEvt = name; }
    void SetNameGeom(const TString name) { fNameGeom = name; }
    void SetType(Int_t type) { fType = type; }

    TH1 *GetHistByName(const TString name="");

    void Paint(Option_t *o="");
    void Draw(Option_t *o="");

    void PrintOutliers(Float_t s) const;

    void SetThreshold(Float_t f, Char_t direction=kIsLowerBound) { fThreshold = f; fUseThreshold=direction; }

    ClassDef(MHCamEvent, 1) // Histogram to sum camera events
};

#endif
