#include "MCollArea.h" 

#include <MLog.h>
#include <TH2.h> 

ClassImp(MCollArea)



MCollArea::MCollArea(const char *name, const char *title) 
{ 
  //
  //   default constructor
  //

  //   initialize the histogram for the distribution r vs E 
  // 
  //   we set the energy range from 1 Gev to 10000 GeV (in log 5 orders
  //   of magnitude) and for each order we take 10 subdivision --> 50 xbins
  //
  //   we set the radius range from 0 m to 500 m with 10 m bin --> 50 ybins

  
  *fName  = name  ? name  : "MCollArea";
  *fTitle = title ? title : "Data to Calculate Coll-Area";
  
  
  fHistAll = new TH2D("collAreaAll", "all showers - Radius vs log(E) distribution", 
		      50, 0., 5., 
		      50, 0., 500. ) ;
  
  fHistSel = new TH2D("collAreaSel", "selected showers - Radius vs log(E) distribution", 
		      50, 0., 5., 
		      50, 0., 500. ) ; 

  fHistColl = new TH1D("collArea", "Collection Area", 
		       50, 0., 5.) ; 
  
} 

MCollArea::~MCollArea()
{ 
  delete fHistAll ; 
  delete fHistSel ; 
  delete fHistColl ; 
} 

void MCollArea::FillAll(Float_t log10E, Float_t radius)
{ 
  fHistAll->Fill(log10E, radius ) ; 
} 

void MCollArea::FillSel(Float_t log10E, Float_t radius)
{ 
  fHistSel->Fill(log10E, radius ) ; 
} 

void MCollArea::DrawAll() 
{ 
  fHistAll->Draw() ; 
} 

void MCollArea::DrawSel() 
{ 
  fHistSel->Draw() ; 
} 

void MCollArea::Draw(Option_t* option) 
{ 
  fHistColl->Draw(option) ; 
} 

void MCollArea::CalculateEffi()
{ 
  //  first of all calculate the efficency
  fHistSel->Divide( fHistAll) ; 
  
  // 
  //  now calculate the Collection area for different 
  //  energies
  //   
  
  Int_t iBinx = ( (TAxis *) fHistSel->GetXaxis())->GetNbins() ; 
  Int_t iBiny = ( (TAxis *) fHistSel->GetYaxis())->GetNbins() ; 
  
  Double_t  r1, r2, eff, A ; 

  for (Int_t ix=1; ix<=iBiny; ix++ ) 
    {
      A = 0. ; 
      for (Int_t iy=1; iy<=iBiny; iy++ ) 
	{ 
	  r1 = ( (TAxis *) fHistSel->GetYaxis())->GetBinLowEdge(iy) ; 
	  r2 = ( (TAxis *) fHistSel->GetYaxis())->GetBinLowEdge(iy+1) ; 
	  eff= fHistSel->GetCellContent(ix, iy) ; 
	  A += eff * 3.141592654 * ( r2*r2 - r1*r1 ) ; 

	}
      cout << ix << " --> " << A
	   << endl ; 
      
      fHistColl->SetBinContent(ix, A ) ; 
      

    } 
} 
