#ifndef __MCollArea__
#define __MCollArea__

#include "MParContainer.h"

#include <TH2.h>

class MCollArea : public MParContainer { 

 private: 
  TH2D  *fHistAll ; //!    all simulated showers 
  TH2D  *fHistSel ; //!    the selected showers
  TH1D  *fHistColl ; //!   the collection area

 public: 
  
  MCollArea(const char *name=NULL, const char *title=NULL) ; 
  ~MCollArea() ; 

  void FillAll(Float_t log10E, Float_t radius) ;  
  void FillSel(Float_t log10E, Float_t radius) ;  
  void DrawAll() ;
  void DrawSel() ;
  void Draw(Option_t* option = "") ; 
  void CalculateEffi() ; 

  ClassDef(MCollArea, 1)  //  Data Container to calculate Collection Area
} ; 

#endif 
