#ifndef MARS_MReportStarguider
#define MARS_MReportStarguider

#ifndef MARS_MReport
#include "MReport.h"
#endif

class MReportStarguider : public MReport
{
private:
    Double_t fDevAz;              // [deg]   azimuth mispointing
    Double_t fDevZd;              // [deg]   zenith  mispointing

    Double_t fNominalZd;          // [deg] Nominal zenith distance
    Double_t fNominalAz;          // [deg] Nominal azimuth

    Float_t  fCameraCenterX;      // [CCD pix] PMT Camera center found
    Float_t  fCameraCenterY;      // [CCD pix] PMT Camera center found

    UInt_t   fNumIdentifiedStars; // Number of stars identified by starguider algorithm

    Double_t fSkyBrightness;      // [au] Sky Brightness as calcualted from the CCD image
    Double_t fMjd;                // Modified Julian Date matching the nominal position

    Int_t InterpreteBody(TString &str, Int_t ver);

public:
    MReportStarguider();

    Double_t GetDevAz() const { return fDevAz; }
    Double_t GetDevZd() const { return fDevZd; }

    Double_t GetNominalZd() const { return fNominalZd; }
    Double_t GetNominalAz() const { return fNominalAz; }

    Float_t  GetCameraCenterX() const { return fCameraCenterX; }
    Float_t  GetCameraCenterY() const { return fCameraCenterY; }

    UInt_t   GetNumIdentifiedStars() const { return fNumIdentifiedStars; }

    Double_t GetSkyBrightness() const { return fSkyBrightness; }
    Double_t GetMjd() const { return fMjd; }

    void Print(Option_t *o="") const;

    ClassDef(MReportStarguider, 2) // Class for STARG-REPORT information
};

#endif
