#ifndef MARS_MJSpectrum
#define MARS_MJSpectrum

#ifndef MARS_MJob
#include <MJob.h>
#endif

class TH1;
class TH1D;

class MH3;
class MTask;
class MParList;
class MDataSet;
class MAlphaFitter;

class MJSpectrum : public MJob
{
private:
    MTask *fCut0;
    MTask *fCut1;
    MTask *fCut2;
    MTask *fCut3;
    MTask *fEstimateEnergy;

    Bool_t fRefill;
    Bool_t fSimpleMode;

    Bool_t  ReadTask(MTask* &task, const char *name) const;
    Bool_t  ReadInput(const MParList &plist);
    void    PrintSetup(const MAlphaFitter &fit) const;
    Float_t ReadHistograms(TH1D &h1, TH1D &h2) const;
    Bool_t  ReadOrigMCDistribution(const MDataSet &set, TH1 &h) const;
    Bool_t  GetThetaDistribution(TH1D &temp1, TH1D &temp2) const;
    void    DisplayResult(const MH3 &mh1) const;
    Bool_t  Refill(MParList &plist, TH1D &h) const;

public:
    MJSpectrum(const char *name=NULL, const char *title=NULL);
    ~MJSpectrum();

    Bool_t Process(const MDataSet &set);

    void EnableRefilling(Bool_t b=kTRUE)  { fRefill=b; }
    void EnableSimpleMode(Bool_t b=kTRUE) { fSimpleMode=b; }

    ClassDef(MJSpectrum, 0) // Proh'gram to calculate spectrum
};

#endif
