/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MHillas                                                                 //
//                                                                         //
// Storage Container for the Hillas parameter                              //
//                                                                         //
// FIXME: Here everybody should find an explanation of the parameters      //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
#include "MHillas.h"

#include <TEllipse.h>

#include "MCerPhotEvt.h"
#include "MCerPhotPix.h"
#include "MGeomCam.h"

#include "MLog.h"

ClassImp(MHillas)

    MHillas::MHillas(const char *name, const char *title) : fEllipse(NULL)
{
    *fName  = name  ? name  : "MHillas";
    *fTitle = title ? title : "Storage container for Hillas parameter of one event";

    // FIXME: Initialization of values missing
}

MHillas::~MHillas()
{
    Clear();
}

void MHillas::Print(Option_t *)
{
    *fLog << "Hillas Parameter:" << endl;
    *fLog << " - Alpha  = " << fAlpha  << endl;
    *fLog << " - Width  = " << fWidth  << endl;
    *fLog << " - Length = " << fLength << endl;
    *fLog << " - Dist   = " << fDist   << endl;
}

void MHillas::Draw(Option_t *)
{
    //
    // Instead of adding MHillas itself to the Pad
    // (s. AppendPad in TObject) we create an ellipse,
    // which is added to the Pad by it's Draw function
    // You can remove it by deleting the Ellipse Object
    // (s. Clear() )
    //

    Clear();

    fEllipse = new TEllipse(cos(fTheta)*fDist, sin(fTheta)*fDist,
                            fWidth, fLength,
                            0, 360, fAlpha);

    fEllipse->SetLineWidth(2);
    fEllipse->Draw();
}

void MHillas::Clear(Option_t *)
{
    if (!fEllipse)
        return;

    delete fEllipse;

    fEllipse = NULL;
}

void MHillas::Calc(MGeomCam &geom, MCerPhotEvt &evt)
{
    const UInt_t nevt = evt.GetNumPixels();

    //
    // calculate mean valu of pixels
    //
    float xav =0;
    float yav =0;
    float spix=0;

    for (UInt_t i=0; i<nevt; i++)
    {
        const MCerPhotPix &pix = evt[i];

        if (!pix.IsPixelUsed())
            continue;

        const MGeomPix &gpix = geom[pix.GetPixId()];

        const float nphot = pix.GetNumPhotons();

        spix += nphot;
        xav  += nphot * gpix.GetX();
        yav  += nphot * gpix.GetY();
    }

    xav /= spix;
    yav /= spix;

    //
    // calculate sdev
    //
    float dis11=0;
    float dis12=0;
    float dis22=0;

    for (UInt_t i=0; i<nevt; i++)
    {
        const MCerPhotPix &pix = evt[i];

        if (!pix.IsPixelUsed())
            continue;

        const MGeomPix &gpix = geom[pix.GetPixId()];

        const float dx = gpix.GetX() - xav;
        const float dy = gpix.GetY() - yav;

        const float nphot = pix.GetNumPhotons();

        dis11 += nphot * dx*dx;
        dis12 += nphot * dx*dy;
        dis22 += nphot * dy*dy;
    }

    //
    // check for orientation
    //
    const float theta = atan(dis12/(dis11-dis22)*2)/2;

    float c = cos(theta);
    float s = sin(theta);

    const float direction = c*xav+s*yav;

    if (direction<0)
    {
        c = -c;
        s = -s;
    }

    float rot1 =  2.0*c*s*dis12 + c*c*dis11 + s*s*dis22;
    float rot2 = -2.0*c*s*dis12 + s*s*dis11 + c*c*dis22;

    rot1 /= spix;
    rot2 /= spix;

    //
    // check for numerical negatives
    //
    if (rot1 < 0) rot1=0;
    if (rot2 < 0) rot2=0;

    //
    // check the rotation of the axis
    //
    const int rotation = rot1<rot2;

    fLength = rotation ? sqrt(rot2) : sqrt(rot1);
    fWidth  = rotation ? sqrt(rot1) : sqrt(rot2);

    fAlpha = 180/kPI*atan((-xav*s+yav*c)/direction);

    fDist  = sqrt(xav*xav + yav*yav);

    fTheta = atan(yav/xav);
    if (xav<0) fTheta += kPI;
}
