#ifndef MPEDESTALCAM_H
#define MPEDESTALCAM_H

#ifndef MPARCONTAINER_H
#include "MParContainer.h"
#endif

#ifndef MPEDESTALPIX_H
#include "MPedestalPix.h"
#endif

#ifndef ROOT_TClonesArray
#include <TClonesArray.h>
#endif

class MPedestalCam : public MParContainer
{
private:
    TClonesArray *fArray;

public:
    MPedestalCam(const char *name=NULL, const char *title=NULL);
    ~MPedestalCam();

    MPedestalPix &operator[](Int_t i) { return *(MPedestalPix*)fArray->At(i); }

    ClassDef(MPedestalCam, 1)	// Storage Container for all pedestal information of the camera
};

#endif

