#include "MGeomCam.h"

#include "MLog.h"
#include "MHexagon.h"

ClassImp(MGeomCam)

MGeomCam::MGeomCam(UInt_t npix, const char *name, const char *title)
{
    *fName  = name  ? name  : "MGeomCam";
    *fTitle = title ? title : "Storage container for  a camera geometry";

    fNumPixels = npix;
    fPixels    = new TObjArray(npix);

    //
    // make sure that the destructor delete all contained objects
    //
    fPixels->SetOwner();

    for (UInt_t i=0; i<npix; i++)
        (*fPixels)[i] = new MGeomPix;
}

void MGeomCam::Draw( Option_t * )
{
    //
    // Draw the Camera
    //
    for (UInt_t i=0; i<fNumPixels; i++)
    {
        MHexagon *el = new MHexagon((*this)[i]);
        el->Draw();
    }
}

void MGeomCam::Print(Option_t *)
{
    //
    //   Print Information about the Geometry of the camera
    //
    *fLog << " Number of Pixels: " << fNumPixels << endl ;

    for (UInt_t i=0; i<fNumPixels; i++ )
    {
        *fLog << " Pixel: " << i << "  ";
        (*this)[i].Print() ;
    }
} 

