#include "MGeomCamMagic.h"

#include "TCanvas.h"

#include "MLog.h"

ClassImp(MGeomCamMagic)

MGeomCamMagic::MGeomCamMagic(const char *name) : MGeomCam(577, name, "Geometry information of Magic Camera")
{
    CreateCam();
}

void MGeomCamMagic::Draw(Option_t *)
{ 
    TCanvas *can = new TCanvas("can", "Camera Geometry", 4 ) ;

    can->Range(-600, -600, 600, 600 ) ;

    MGeomCam::Draw();
}

void MGeomCamMagic::CreateCam()
{
    //
    //   fill the geometry class with the coordinates of the MAGIC camera
    //
    *fLog << " Creating Magic geometry " << endl ;

    //
    //   here define the hardwire things of the magic telescope
    //
    const Float_t xtemp[577] = {
        +000.000,   30.000,   15.000,  -15.000,  -30.000,  -15.000,   15.000,   60.000,
        +045.000,   30.000,    0.000,  -30.000,  -45.000,  -60.000,  -45.000,  -30.000,
        +000.000,   30.000,   45.000,   90.000,   75.000,   60.000,   45.000,   15.000,
        -015.000,  -45.000,  -60.000,  -75.000,  -90.000,  -75.000,  -60.000,  -45.000,
        -015.000,   15.000,   45.000,   60.000,   75.000,  120.000,  105.000,   90.000,
        +075.000,   60.000,   30.000,    0.000,  -30.000,  -60.000,  -75.000,  -90.000,
        -105.000, -120.000, -105.000,  -90.000,  -75.000,  -60.000,  -30.000,    0.000,
        +030.000,   60.000,   75.000,   90.000,  105.000,  150.000,  135.000,  120.000,
        +105.000,   90.000,   75.000,   45.000,   15.000,  -15.000,  -45.000,  -75.000,
        -090.000, -105.000, -120.000, -135.000, -150.000, -135.000, -120.000, -105.000,
        -090.000,  -75.000,  -45.000,  -15.000,   15.000,   45.000,   75.000,   90.000,
        +105.000,  120.000,  135.000,  180.000,  165.000,  150.000,  135.000,  120.000,
        +105.000,   90.000,   60.000,   30.000,    0.000,  -30.000,  -60.000,  -90.000,
        -105.000, -120.000, -135.000, -150.000, -165.000, -180.000, -165.000, -150.000,
        -135.000, -120.000, -105.000,  -90.000,  -60.000,  -30.000,    0.000,   30.000,
        +060.000,   90.000,  105.000,  120.000,  135.000,  150.000,  165.000,  210.000,
        +195.000,  180.000,  165.000,  150.000,  135.000,  120.000,  105.000,   75.000,
        +045.000,   15.000,  -15.000,  -45.000,  -75.000, -105.000, -120.000, -135.000,
        -150.000, -165.000, -180.000, -195.000, -210.000, -195.000, -180.000, -165.000,
        -150.000, -135.000, -120.000, -105.000,  -75.000,  -45.000,  -15.000,   15.000,
        +045.000,   75.000,  105.000,  120.000,  135.000,  150.000,  165.000,  180.000,
        +195.000,  240.000,  225.000,  210.000,  195.000,  180.000,  165.000,  150.000,
        +135.000,  120.000,   90.000,   60.000,   30.000,    0.000,  -30.000,  -60.000,
        -090.000, -120.000, -135.000, -150.000, -165.000, -180.000, -195.000, -210.000,
        -225.000, -240.000, -225.000, -210.000, -195.000, -180.000, -165.000, -150.000,
        -135.000, -120.000,  -90.000,  -60.000,  -30.000,    0.000,   30.000,   60.000,
        +090.000,  120.000,  135.000,  150.000,  165.000,  180.000,  195.000,  210.000,
        +225.000,  270.000,  255.000,  240.000,  225.000,  210.000,  195.000,  180.000,
        +165.000,  150.000,  135.000,  105.000,   75.000,   45.000,   15.000,  -15.000,
        -045.000,  -75.000, -105.000, -135.000, -150.000, -165.000, -180.000, -195.000,
        -210.000, -225.000, -240.000, -255.000, -270.000, -255.000, -240.000, -225.000,
        -210.000, -195.000, -180.000, -165.000, -150.000, -135.000, -105.000,  -75.000,
        -045.000,  -15.000,   15.000,   45.000,   75.000,  105.000,  135.000,  150.000,
        +165.000,  180.000,  195.000,  210.000,  225.000,  240.000,  255.000,  300.000,
        +285.000,  270.000,  255.000,  240.000,  225.000,  210.000,  195.000,  180.000,
        +165.000,  150.000,  120.000,   90.000,   60.000,   30.000,    0.000,  -30.000,
        -060.000,  -90.000, -120.000, -150.000, -165.000, -180.000, -195.000, -210.000,
        -225.000, -240.000, -255.000, -270.000, -285.000, -300.000, -285.000, -270.000,
        -255.000, -240.000, -225.000, -210.000, -195.000, -180.000, -165.000, -150.000,
        -120.000,  -90.000,  -60.000,  -30.000,    0.000,   30.000,   60.000,   90.000,
        +120.000,  150.000,  165.000,  180.000,  195.000,  210.000,  225.000,  240.000,
        +255.000,  270.000,  285.000,  330.000,  315.000,  300.000,  285.000,  270.000,
        +255.000,  240.000,  225.000,  210.000,  195.000,  180.000,  165.000,  135.000,
        +105.000,   75.000,   45.000,   15.000,  -15.000,  -45.000,  -75.000, -105.000,
        -135.000, -165.000, -180.000, -195.000, -210.000, -225.000, -240.000, -255.000,
        -270.000, -285.000, -300.000, -315.000, -330.000, -315.000, -300.000, -285.000,
        -270.000, -255.000, -240.000, -225.000, -210.000, -195.000, -180.000, -165.000,
        -135.000, -105.000,  -75.000,  -45.000,  -15.000,   15.000,   45.000,   75.000,
        +105.000,  135.000,  165.000,  180.000,  195.000,  210.000,  225.000,  240.000,
        +255.000,  270.000,  285.000,  300.000,  315.000,  360.000,  330.000,  300.000,
        +270.000,  240.000,  210.000,  150.000,   90.000,   30.000,  -30.000,  -90.000,
        -150.000, -210.000, -240.000, -270.000, -300.000, -330.000, -360.000, -360.000,
        -330.000, -300.000, -270.000, -240.000, -210.000, -150.000,  -90.000,  -30.000,
        +030.000,   90.000,  150.000,  210.000,  240.000,  270.000,  300.000,  330.000,
        +360.000,  420.000,  390.000,  360.000,  330.000,  300.000,  270.000,  240.000,
        +180.000,  120.000,   60.000,    0.000,  -60.000, -120.000, -180.000, -240.000,
        -270.000, -300.000, -330.000, -360.000, -390.000, -420.000, -420.000, -390.000,
        -360.000, -330.000, -300.000, -270.000, -240.000, -180.000, -120.000,  -60.000,
        +000.000,   60.000,  120.000,  180.000,  240.000,  270.000,  300.000,  330.000,
        +360.000,  390.000,  420.000,  480.000,  450.000,  420.000,  390.000,  360.000,
        +330.000,  300.000,  270.000,  210.000,  150.000,   90.000,   30.000,  -30.000,
        -090.000, -150.000, -210.000, -270.000, -300.000, -330.000, -360.000, -390.000,
        -420.000, -450.000, -480.000, -480.000, -450.000, -420.000, -390.000, -360.000,
        -330.000, -300.000, -270.000, -210.000, -150.000,  -90.000,  -30.000,   30.000,
        +090.000,  150.000,  210.000,  270.000,  300.000,  330.000,  360.000,  390.000,
        +420.000,  450.000,  480.000,  540.000,  510.000,  480.000,  450.000,  420.000,
        +390.000,  360.000,  330.000,  300.000,  240.000,  180.000,  120.000,   60.000,
        +000.000,  -60.000, -120.000, -180.000, -240.000, -300.000, -330.000, -360.000,
        -390.000, -420.000, -450.000, -480.000, -510.000, -540.000, -540.000, -510.000,
        -480.000, -450.000, -420.000, -390.000, -360.000, -330.000, -300.000, -240.000,
        -180.000, -120.000,  -60.000,    0.000,   60.000,  120.000,  180.000,  240.000,
        +300.000,  330.000,  360.000,  390.000,  420.000,  450.000,  480.000,  510.000,
        +540.000
    };

    const Float_t ytemp[577] = {
        +000.000,    0.000,   25.981,   25.981,    0.000,  -25.981,  -25.981,    0.000,
        +025.981,   51.961,   51.961,   51.961,   25.981,    0.000,  -25.981,  -51.961,
        -051.961,  -51.961,  -25.981,    0.000,   25.981,   51.961,   77.942,   77.942,
        +077.942,   77.942,   51.961,   25.981,    0.000,  -25.981,  -51.961,  -77.942,
        -077.942,  -77.942,  -77.942,  -51.961,  -25.981,    0.000,   25.981,   51.961,
        +077.942,  103.923,  103.923,  103.923,  103.923,  103.923,   77.942,   51.961,
        +025.981,    0.000,  -25.981,  -51.961,  -77.942, -103.923, -103.923, -103.923,
        -103.923, -103.923,  -77.942,  -51.961,  -25.981,    0.000,   25.981,   51.961,
        +077.942,  103.923,  129.904,  129.904,  129.904,  129.904,  129.904,  129.904,
        +103.923,   77.942,   51.961,   25.981,    0.000,  -25.981,  -51.961,  -77.942,
        -103.923, -129.904, -129.904, -129.904, -129.904, -129.904, -129.904, -103.923,
        -077.942,  -51.961,  -25.981,    0.000,   25.981,   51.961,   77.942,  103.923,
        +129.904,  155.885,  155.885,  155.885,  155.885,  155.885,  155.885,  155.885,
        +129.904,  103.923,   77.942,   51.961,   25.981,    0.000,  -25.981,  -51.961,
        -077.942, -103.923, -129.904, -155.885, -155.885, -155.885, -155.885, -155.885,
        -155.885, -155.885, -129.904, -103.923,  -77.942,  -51.961,  -25.981,    0.000,
        +025.981,   51.961,   77.942,  103.923,  129.904,  155.885,  181.865,  181.865,
        +181.865,  181.865,  181.865,  181.865,  181.865,  181.865,  155.885,  129.904,
        +103.923,   77.942,   51.961,   25.981,    0.000,  -25.981,  -51.961,  -77.942,
        -103.923, -129.904, -155.885, -181.865, -181.865, -181.865, -181.865, -181.865,
        -181.865, -181.865, -181.865, -155.885, -129.904, -103.923,  -77.942,  -51.961,
        -025.981,    0.000,   25.981,   51.961,   77.942,  103.923,  129.904,  155.885,
        +181.865,  207.846,  207.846,  207.846,  207.846,  207.846,  207.846,  207.846,
        +207.846,  207.846,  181.865,  155.885,  129.904,  103.923,   77.942,   51.961,
        +025.981,    0.000,  -25.981,  -51.961,  -77.942, -103.923, -129.904, -155.885,
        -181.865, -207.846, -207.846, -207.846, -207.846, -207.846, -207.846, -207.846,
        -207.846, -207.846, -181.865, -155.885, -129.904, -103.923,  -77.942,  -51.961,
        -025.981,    0.000,   25.981,   51.961,   77.942,  103.923,  129.904,  155.885,
        +181.865,  207.846,  233.827,  233.827,  233.827,  233.827,  233.827,  233.827,
        +233.827,  233.827,  233.827,  233.827,  207.846,  181.865,  155.885,  129.904,
        +103.923,   77.942,   51.961,   25.981,    0.000,  -25.981,  -51.961,  -77.942,
        -103.923, -129.904, -155.885, -181.865, -207.846, -233.827, -233.827, -233.827,
        -233.827, -233.827, -233.827, -233.827, -233.827, -233.827, -233.827, -207.846,
        -181.865, -155.885, -129.904, -103.923,  -77.942,  -51.961,  -25.981,    0.000,
        +025.981,   51.961,   77.942,  103.923,  129.904,  155.885,  181.865,  207.846,
        +233.827,  259.808,  259.808,  259.808,  259.808,  259.808,  259.808,  259.808,
        +259.808,  259.808,  259.808,  259.808,  233.827,  207.846,  181.865,  155.885,
        +129.904,  103.923,   77.942,   51.961,   25.981,    0.000,  -25.981,  -51.961,
        -077.942, -103.923, -129.904, -155.885, -181.865, -207.846, -233.827, -259.808,
        -259.808, -259.808, -259.808, -259.808, -259.808, -259.808, -259.808, -259.808,
        -259.808, -259.808, -233.827, -207.846, -181.865, -155.885, -129.904, -103.923,
        -077.942,  -51.961,  -25.981,    0.000,   25.981,   51.961,   77.942,  103.923,
        +129.904,  155.885,  181.865,  207.846,  233.827,  259.808,  285.788,  285.788,
        +285.788,  285.788,  285.788,  285.788,  285.788,  285.788,  285.788,  285.788,
        +285.788,  285.788,  259.808,  233.827,  207.846,  181.865,  155.885,  129.904,
        +103.923,   77.942,   51.961,   25.981,    0.000,  -25.981,  -51.961,  -77.942,
        -103.923, -129.904, -155.885, -181.865, -207.846, -233.827, -259.808, -285.788,
        -285.788, -285.788, -285.788, -285.788, -285.788, -285.788, -285.788, -285.788,
        -285.788, -285.788, -285.788, -259.808, -233.827, -207.846, -181.865, -155.885,
        -129.904, -103.923,  -77.942,  -51.961,  -25.981,   34.641,   86.603,  138.564,
        +190.526,  242.487,  294.449,  329.090,  329.090,  329.090,  329.090,  329.090,
        +329.090,  294.449,  242.487,  190.526,  138.564,   86.603,   34.641,  -34.641,
        -086.603, -138.564, -190.526, -242.487, -294.449, -329.090, -329.090, -329.090,
        -329.090, -329.090, -329.090, -294.449, -242.487, -190.526, -138.564,  -86.603,
        -034.641,   34.641,   86.603,  138.564,  190.526,  242.487,  294.449,  346.410,
        +381.051,  381.051,  381.051,  381.051,  381.051,  381.051,  381.051,  346.410,
        +294.449,  242.487,  190.526,  138.564,   86.603,   34.641,  -34.641,  -86.603,
        -138.564, -190.526, -242.487, -294.449, -346.410, -381.051, -381.051, -381.051,
        -381.051, -381.051, -381.051, -381.051, -346.410, -294.449, -242.487, -190.526,
        -138.564,  -86.603,  -34.641,   34.641,   86.603,  138.564,  190.526,  242.487,
        +294.449,  346.410,  398.372,  433.013,  433.013,  433.013,  433.013,  433.013,
        +433.013,  433.013,  433.013,  398.372,  346.410,  294.449,  242.487,  190.526,
        +138.564,   86.603,   34.641,  -34.641,  -86.603, -138.564, -190.526, -242.487,
        -294.449, -346.410, -398.372, -433.013, -433.013, -433.013, -433.013, -433.013,
        -433.013, -433.013, -433.013, -398.372, -346.410, -294.449, -242.487, -190.526,
        -138.564,  -86.603,  -34.641,   34.641,   86.603,  138.564,  190.526,  242.487,
        +294.449,  346.410,  398.372,  450.333,  484.974,  484.974,  484.974,  484.974,
        +484.974,  484.974,  484.974,  484.974,  484.974,  450.333,  398.372,  346.410,
        +294.449,  242.487,  190.526,  138.564,   86.603,   34.641,  -34.641,  -86.603,
        -138.564, -190.526, -242.487, -294.449, -346.410, -398.372, -450.333, -484.974,
        -484.974, -484.974, -484.974, -484.974, -484.974, -484.974, -484.974, -484.974,
        -450.333, -398.372, -346.410, -294.449, -242.487, -190.526, -138.564,  -86.603,
        -034.641
    };

    const Float_t rtemp[577] = {
        30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
        30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
        30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
        30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
        30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
        30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
        30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
        30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
        30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
        30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
        30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
        30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
        30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
        30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
        30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
        30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
        30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
        30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
        30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
        30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
        30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
        30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
        30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
        30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
        30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
        30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
        30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
        30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
        30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
        30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
        30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
        30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
        30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
        30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
        30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
        30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
        30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
        30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
        30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
        30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
        30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
        30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
        30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
        30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
        30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
        30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
        30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
        30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
        30.00,30.00,30.00,30.00,30.00,30.00,30.00,30.00,
        30.00,30.00,30.00,30.00,30.00,60.00,60.00,60.00,
        60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
        60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
        60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
        60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
        60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
        60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
        60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
        60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
        60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
        60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
        60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
        60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
        60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
        60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
        60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
        60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
        60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
        60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
        60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
        60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
        60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
        60.00,60.00,60.00,60.00,60.00,60.00,60.00,60.00,
        60.00  } ;

    //
    //   fill the pixels list with this data
    //

    for (UInt_t i = 0; i<GetNumPixels(); i++)
    {
        (*this)[i].Set(xtemp[i], ytemp[i], rtemp[i]) ;
        //fPixels->Add( new MGeomPix() ;
    }
}

