void readCT1()
{
    MParList plist;

    MGeomCamMagic camct1;
    MHillas       hillas;
    MTaskList     tlist;

    plist->AddToList(&camct1);
    plist->AddToList(&hillas);
    plist->AddToList(&tlist);

    MCT1ReadAscii readct1("CT1_99_on1.dat") ;
    MHillasCalc hcalc;

    tlist.AddToList(&readct1);
    tlist.AddToList(&hcalc);

    MEvtLoop evtloop;
    evtloop.SetParList(&plist);

    if (!evtloop.PreProcess())
        return;

    MCerPhotEvt &phevt = *(MCerPhotEvt*)plist->FindObject("MCerPhotEvt");

    Int_t icount = 0 ;
    MCamDisplay display(&camct1) ;

    while (readct1.Process())
    {
        cout << "Event: " << icount++  << endl  ;

        if (icount < 45 )
            continue;

        display.DrawPhotNum(&phevt);
        gClient->HandleInput();
        if(getchar()=='q')
            break;

        phevt.CleanLevel1();
        phevt.CleanLevel2();
        display.DrawPhotNum(&phevt);
        gClient->HandleInput();
        if(getchar()=='q')
            break;

        phevt.CleanLevel3();

        hcalc.Process();

        hillas.Print();
        hillas.Draw();

        display.DrawPhotNum(&phevt);

        gClient->HandleInput();
        if(getchar()=='q')
            break;

        hillas.Clear();
    } 

    evtloop.PostProcess();
}
