#ifndef MCERPHOTEVT_H
#define MCERPHOTEVT_H

#ifndef MAGIC_h
#include "MAGIC.h"
#endif
#ifndef ROOT_TClonesArray
#include "TClonesArray.h"
#endif
#ifndef MPARCONTAINER_H
#include "MParContainer.h"
#endif
#ifndef MCAMNEIGHBOR_H
#include "MCamNeighbor.h"
#endif

class MCerPhotPix;

class MCerPhotEvt : public MParContainer
{
private:

    Int_t         fNumPixels;
    TClonesArray *fPixels;

    MCamNeighbor  fNN;   //! the class with the information about neighbors

public:
  MCerPhotEvt(const char *name=NULL, const char *title=NULL) ;

  void Draw(Option_t* option = "" ) ; 

  Int_t    GetNumPixels() ;

  void AddPixel(Int_t id, Float_t nph, Float_t err );

  void Clear(Option_t *opt=NULL) ;

  void Print(Option_t *opt=NULL) ;

  void CleanLevel1() ; 
  void CleanLevel2() ; 
  void CleanLevel3() ; 
  
  Bool_t  IsPixelExisting( Int_t id ) ;
  Bool_t  IsPixelUsed    ( Int_t id ) ;
  Bool_t  IsPixelCore    ( Int_t id ) ;
 
  Float_t GetNumPhotonsMin();
  Float_t GetNumPhotonsMax();

  MCerPhotPix &operator[](int i) { return *(MCerPhotPix*)(fPixels->At(i)); }

  ClassDef(MCerPhotEvt, 1)    // class for Nphotons Events
}; 

#endif

