#ifndef MHILLAS_H
#define MHILLAS_H

#ifndef MPARCONTAINER_H
#include "MParContainer.h"
#endif

class TEllipse;

class MGeomCam;
class MCerPhotEvt;

class MHillas : public MParContainer
{
private:
    Float_t fAlpha;     // Angle between the length axis of the ellipse and the camera center
    Float_t fTheta;     // Angle between the x axis and the center of the ellipse
    Float_t fWidth;     // Width of the ellipse
    Float_t fLength;    // Length of the ellipse
    Float_t fSize;      // Size of the ellipse
    Float_t fDist;      // Distance of the ellipse COM from the camera center

    TEllipse *fEllipse; //! Graphical Object to Display Ellipse

public:
    MHillas(const char *name=NULL, const char *title=NULL);
    ~MHillas();

    void Calc(MGeomCam &geom, MCerPhotEvt &pix);

    void Print(Option_t *opt=NULL);
    void Draw(Option_t *opt=NULL);

    void Clear(Option_t *opt=NULL);

    ClassDef(MHillas, 1) // Storage Container for Hillas Parameter
};

#endif

