#include "MGeomCamCT1.h"


#include <math.h>     // floor
#include "TCanvas.h"

#include "MLog.h"

ClassImp(MGeomCamCT1)

MGeomCamCT1::MGeomCamCT1(const char *name) : MGeomCam(127, name, "Geometry information of CT1 camera")
{
    CreateCam();
} 

void MGeomCamCT1::Draw( Option_t * )
{ 
    TCanvas *can = new TCanvas("can", "Camera Geometry", 4 ) ;

    can->Range(-175, -175, 175, 175 ) ;

    MGeomCam::Draw();
} 

void MGeomCamCT1::CreateCam()
{
    //
    // fill the geometry class with the coordinates of the CT1 camera
    //
    *fLog << " Create CT1 geometry " << endl;

    //
    // this algorithm is from Martin Kestel originally
    // it was punt into a root/C++ context by Harald Kornmayer and Thomas Bretz
   
    const Float_t pixdiameter = 21 ;    // units are cm

    //
    //  add the first pixel to the list
    //
    (*this)[0].Set(0, 0, pixdiameter);
    //fPixels->Add( new MGeomPix( ) ;

    const Float_t kS32  = sqrt(3)/2;
    const Float_t kPI23 = kPI*2/3;

    Int_t pixnum = 1;

    for (Int_t ringcounter=1; ringcounter<7; ringcounter++) {
        //
        // calc. numofpix in ring number i first
        //
        const Int_t numpixthisring = ringcounter*6;

        //
        // calc. coords for this ring counting from the
        // starting number to the ending number
        //
        for (Int_t ipix = 0; ipix < numpixthisring; ipix++) {

            Float_t ang     = 60.0/ringcounter * ipix;
            Float_t fracang = ang - 60*(int)floor(ang/60);

            ang     /= kRad2Deg;
            fracang /= kRad2Deg;

            Float_t rad  = pixdiameter * ringcounter;
                    rad *= sin(kPI23-fracang) * kS32;

            //
            //   fill the Data into the array
            //

            (*this)[pixnum++].Set(rad * cos(ang),
                                  rad * sin(ang),
                                  pixdiameter);
            // fPixels->Add( new MGeomPix( ) ;
        }
    }
}

