/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Keiichi Mase 10/2004 <mailto:mase@mppmu.mpg.de>
!              Markus Meyer 10/2004 <mailto:meyer@astro.uni-wuerzburg.de>
!
!   Copyright: MAGIC Software Development, 2000-2004
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//
// MMuonSetup
//
// Storage Container for parameter for the muon analysis
//
//
//  Input Containers:
//   [MSignalCam]
//
/////////////////////////////////////////////////////////////////////////////
#include "MMuonSetup.h"

#include <fstream>

#include "MLog.h"

using namespace std;

ClassImp(MMuonSetup);

// --------------------------------------------------------------------------
//
// Default constructor.
//
MMuonSetup::MMuonSetup(const char *name, const char *title)
{
    fName  = name  ? name  : "MMuonSetup";
    fTitle = title ? title : "Muon calibration parameters";

    fMargin = 60.;  // in mm
    fArcPhiThres  = 30.;
    fArcWidthThres  = 30.;
    fArcPhiBinNum = 20;
    fArcPhiHistStartVal = -180.; // deg.
    fArcPhiHistEndVal   = 180.;  // deg.
    fArcWidthBinNum = 28;
    fArcWidthHistStartVal = 0.3; // deg.
    fArcWidthHistEndVal   = 1.7; // deg.
}

// --------------------------------------------------------------------------
//
MMuonSetup::~MMuonSetup()
{
}
