#ifndef MARS_MHMuonPar
#define MARS_MHMuonPar

#ifndef MARS_MH
#include "MH.h"
#endif
#ifndef ROOT_TH1
#include <TH1.h>
#endif
#ifndef ROOT_TProfile
#include <TProfile.h>
#endif

class MHillas;
class MMuonSearchPar;
class MMuonCalibPar;
class MGeomCam;

class MHMuonPar : public MH
{
private:
    TH1F fHistRadius;  //

    TH1F fHistArcWidth;   //

    TProfile fHistBroad;  // Area of used pixels

    TProfile fHistSize;      // [ratio] concentration ratio: sum of the two highest pixels / fSize

    MGeomCam *fGeomCam; //! Camera geometry for plots (for the moment this is a feature for a loop only!)

    MMuonSearchPar *fMuonSearchPar;//!

    MMuonCalibPar *fMuonCalibPar;//!

    Float_t fMm2Deg;

public:
    MHMuonPar(const char *name=NULL, const char *title=NULL);

    Bool_t SetupFill(const MParList *plist);
    Bool_t Fill(const MParContainer *par, const Stat_t w=1);

    TH1 *GetHistByName(const TString name);

    TH1F &GetHistRadius()  { return fHistRadius; }

    TH1F &GetHistArcWidth()   { return fHistArcWidth; }

    TProfile &GetHistBroad()  { return fHistBroad; }

    TProfile &GetHistSize()      { return fHistSize; }

    void Draw(Option_t *opt="");

    ClassDef(MHMuonPar, 1) // Histograms of new image parameters
};

#endif


