#ifndef MARS_MMuonSetup
#define MARS_MMuonSetup

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MMuonSetup : public MParContainer
{
private:
  Float_t fMargin;        // margin to evaluate muons [mm]. The defaut value is 60 mm, corresponding to 0.2 deg. This value can be changed by using the function of SetMargin
  Float_t fArcPhiThres;   // The threshold value to define arc phi
  Float_t fArcWidthThres; // The threshold value to define arc width


public:
  MMuonSetup(const char *name=NULL, const char *title=NULL);
  ~MMuonSetup();
  
  Int_t   fArcPhiBinNum;         // The bin number for the histogram of arc phi. You may change this value. However, if you change this, YOU ALSO HAVE TO CHANGE THE THRESHOLD VALUE TO GET ARC LENGTH.
  Int_t   fArcWidthBinNum;       // The bin number for the histogram of arc wid
  Float_t fArcPhiHistStartVal;   // The starting value for the histogram of arc phi
  Float_t fArcPhiHistEndVal;     // The end value for the histogram of arc phi
  Float_t fArcWidthHistStartVal; // The starting value for the histogram of arc width
  Float_t fArcWidthHistEndVal;   // The end value for the histogram of arc width

  Float_t GetMargin()         const { return fMargin; }
  Float_t GetArcPhiThres()    const { return fArcPhiThres; }
  Float_t GetArcWidthThres()  const { return fArcWidthThres; }
  Float_t GetArcPhiBinNum()   const { return fArcPhiBinNum; }
  Float_t GetArcWidthBinNum() const { return fArcWidthBinNum; }
  
  void    SetMargin(Float_t margin)       { fMargin = margin; }
  void    SetArcPhiThres(Float_t thres)   { fArcPhiThres = thres; }
  void    SetArcWidthThres(Float_t thres) { fArcWidthThres = thres; }
  void    SetArcPhiBinNum(Int_t num)      { fArcPhiBinNum = num; }
  void    SetArcWidthBinNum(Int_t num)    { fArcWidthBinNum = num; }
  
  ClassDef(MMuonSetup, 1) // Container to hold muon parameters for the whole sample
};
    
#endif
