#ifndef MARS_MJCut
#define MARS_MJCut

#ifndef MARS_MJob
#include "MJob.h"
#endif

class MTask;
class MDataSet;
class MParList;
class MWriteRootFile;

class MJCut : public MJob
{
private:
    Bool_t  fStoreSummary;
    Bool_t  fStoreResult;
    Bool_t  fWriteOnly;
    Bool_t  fIsWobble;
    Bool_t  fIsMonteCarlo;
    Bool_t  fFullDisplay;
    //Bool_t  fSubstraction;

    TString fNameSummary;
    TString fNameResult;
    TString fNameOutput;

    //MTask *fEstimateEnergy;
    MTask *fCalcHadronness;

    TString GetOutputFile(UInt_t num) const;
    Bool_t  CheckEnvLocal();
    void    SetupWriter(MWriteRootFile *write, const char *name) const;
    Bool_t  WriteTasks(UInt_t num, TObjArray &cont) const;
    Bool_t  WriteResult(const MParList &plist, UInt_t num) const;
    void    DisplayResult(const MParList &plist) const;

    Bool_t  CanStoreSummary() const { return !fPathOut.IsNull() && fStoreSummary; }
    Bool_t  CanStoreResult() const  { return !fPathOut.IsNull() && fStoreResult;  }

public:
    MJCut(const char *name=NULL, const char *title=NULL);
    ~MJCut();

    Bool_t Process(const MDataSet &set);

    void EnableStorageOfSummary(Bool_t b=kTRUE)  { fStoreSummary = b; } // See SetNameSummary
    void EnableStorageOfResult(Bool_t b=kTRUE)   { fStoreResult  = b; } // See SetNameResult
    void EnableWriteOnly(Bool_t b=kTRUE)         { fWriteOnly    = b; }
    void EnableWobbleMode(Bool_t b=kTRUE)        { fIsWobble     = b; }
    void EnableMonteCarloMode(Bool_t b=kTRUE)    { fIsMonteCarlo = b; }
    void EnableFullDisplay(Bool_t b=kTRUE)       { fFullDisplay  = b; }
    //void EnableSubstraction(Bool_t b=kTRUE)      { fSubstraction = b; }

    void SetNameSummaryFile(const char *name="");
    void SetNameResultFile(const char *name="");
    void SetNameOutFile(const char *name="")      { fNameOutput=name; }

    //void SetEnergyEstimator(const MTask *task=0);
    void SetHadronnessCalculator(const MTask *task=0);

    ClassDef(MJCut, 0) // Standard program to perform g/h-separation cuts
};

#endif
