/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MCT1ReadAscii                                                           //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#include "MCT1ReadAscii.h"

#include <fstream.h>

#include "MLog.h"
#include "MLogManip.h"

#include "MParList.h"
#include "MCerPhotEvt.h"
#include "MCT1Pedestals.h"

ClassImp(MCT1ReadAscii)

MCT1ReadAscii::MCT1ReadAscii(const char *fname,
			     const char *name, 
			     const char *title)
{
    *fName  = name  ? name  : "MCT1ReadAscii";
    *fTitle = title ? title : "Task to loop over events in CT1 ascii file";

    //
    // remember file name for opening the file in the preprocessor
    //
    fFileName = fname;
}

Bool_t MCT1ReadAscii::PreProcess(MParList *pList)
{
    //
    // Preprocessing
    //

    //
    // open the input stream and check if it is really open (file exists?)
    //
    fIn = new ifstream(fFileName);
    if (!(*fIn))
    {
        *fLog << dbginf << "Cannot open file." << endl;
        return kFALSE;
    }

    //
    //  look for the MCerPhotEvt class in the plist
    //
    fNphot = (MCerPhotEvt*)pList->FindCreateObj("MCerPhotEvt");
    if (!fNphot)
        return kFALSE;

    //
    //  look for the pedestal class in the plist
    //
    fPedest = (MCT1Pedestals*)pList->FindCreateObj("MCT1Pedestals");
    if (!fPedest)
        return kFALSE;

    return kTRUE;
}

Bool_t MCT1ReadAscii::Process()
{
    //
    // FIXME. This function should switch between reading pedestals and
    // reading event data by the 'switch entry'.
    // After reading it should set the InputStreamID correctly.
    // ( should use MPedestalCam )
    //
 
    //
    // read in a dummy number (event number)
    //
    Int_t dummyI;
    *fIn >> dummyI;

    //
    // check if we are done
    //
    if (fIn->eof())
        return kFALSE;

    //
    // if the first number is negativ this is a pedestal line:
    // read in pedestals
    //
    if (dummyI < 0)
        fPedest->AsciiRead(*fIn);

    //
    // five unsused numbers
    //
    *fIn >> dummyI;   // ener
    *fIn >> dummyI;   // zenang
    *fIn >> dummyI;   // sec1
    *fIn >> dummyI;   // sec2

    //
    // clear the list of cerphot-events
    //
    fNphot->Clear();

    //
    // read in the number of cerenkov photons and add the 'new' pixel
    // too the list with it's id, number of photons and error
    //
    for (Int_t i = 0; i<127; i++ )
    {
        Float_t nphot;

        *fIn >> nphot;

        if (nphot > 0.0)
            fNphot->AddPixel(i, nphot, (*fPedest)[i]);
    }

    return kTRUE;
}

Bool_t MCT1ReadAscii::PostProcess()
{
    //
    // close and delete the input stream
    //
    delete fIn;

    return kTRUE;
}

