#ifndef MHFADCPIX_H
#define MHFADCPIX_H

#ifndef MAGIC_H
#include "MAGIC.h"
#endif

#ifndef ROOT_TH1
#include <TH1.h>
#endif

class MHFadcPix : public TObject
{
private:
    TH1F *fHistHi;
    TH1F *fHistLo;

public:
    MHFadcPix(UInt_t pixid)
    {
        Char_t tmp1[40];
        Char_t tmp2[40];

        sprintf(tmp1, "high%d", pixid);
        sprintf(tmp2, "high gain Pixel %d", pixid);

        fHistHi =  new TH1F(tmp1, tmp2, 256, 0, 255);

        sprintf(tmp1, "low %d", pixid);
        sprintf(tmp2, "low gain Pixel %d", pixid);

        fHistLo =  new TH1F(tmp1, tmp2, 256, 0, 255);
    }
    ~MHFadcPix()
    {
        delete fHistHi;
        delete fHistLo;
    }
    TH1F *GetHistHi() { return fHistHi; }
    TH1F *GetHistLo() { return fHistLo; }

    void FillHi(Byte_t i) { fHistHi->Fill(i); }
    void FillLo(Byte_t i) { fHistLo->Fill(i); }

    void DrawHi() { fHistHi->Draw(); }
    void DrawLo() { fHistLo->Draw(); }

    void Draw(Option_t *opt=NULL);

    ClassDef(MHFadcPix, 1)
};

#endif

