///////////////////////////////////////////////////////////////////////
//
// MHHillas
//
// This class contains histograms for every Hillas parameter
//
///////////////////////////////////////////////////////////////////////

#include "MHHillas.h"

#include <TH1.h>
#include <TPad.h>

#include "MHillas.h"

ClassImp(MHHillas)

MHHillas::MHHillas (const char *name, const char *title)
{
    //
    //  default constructor
    //  creates an a list of histograms for all pixels and both gain channels
    //

    //
    //   set the name and title of this object
    //
    
    *fName  = name  ? name  : "MHHillas" ;
    *fTitle = title ? title : "Container for Hillas histograms" ;

    //
    //   loop over all Pixels and create two histograms
    //   one for the Low and one for the High gain
    //   connect all the histogram with the container fHist
    //
    fAlpha  = new TH1F("Alpha [deg]", "Alpha of Hillas",   90, 0,  90);
    fWidth  = new TH1F("Width [mm]",  "Width of Hillas",  150, 0, 150);
    fLength = new TH1F("Length [mm]", "Length of Hillas", 150, 0, 150);
    fDist   = new TH1F("Dist [mm]",   "Dist of Hillas",   200, 0, 200);
}

MHHillas::~MHHillas()
{
    delete fAlpha;
    delete fWidth;
    delete fLength;
    delete fDist;
}

void MHHillas::Fill(MHillas *par)
{
    fAlpha ->Fill(par->GetAlpha());
    fWidth ->Fill(par->GetWidth());
    fLength->Fill(par->GetLength());
    fDist  ->Fill(par->GetDist());
}

#include <TCanvas.h>
void MHHillas::Draw(Option_t *)
{

    TCanvas *c = new TCanvas("Hillas", "Histograms of Hillas Parameters");
    c->Divide(2,2);

    c->cd(1);
    fAlpha->Draw();
    c->cd(2);
    fLength->Draw();
    c->cd(3);
    fDist->Draw();
    c->cd(4);
    fWidth->Draw();

    c->Modified();
    c->Update();
}
