/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MCT1Pedestals                                                           //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
#include "MCT1Pedestals.h"

#include <fstream.h>

#include "MLog.h"

ClassImp(MCT1Pedestals)

MCT1Pedestals::MCT1Pedestals(const char *name, const char *title)
{
    *fName  = name  ? name  : "MCT1Pedestals";
    *fTitle = title ? title : "Storage container for CT1 Pedestals";

    //
    // set the pedestals to default values
    //
    for (Int_t i = 0; i<127; i++ )
        fPedest[i] = 1.5;
}

void MCT1Pedestals::AsciiRead (ifstream &fin)
{
    *fLog << "MCT1Pedestals::AsciiRead: Reading Pedestals..." << endl;

    Int_t   dummyI;
    Float_t dummyF;

    //
    // skip the next 4 values
    //
    fin >> dummyF; 
    fin >> dummyF; 
    fin >> dummyF; 
    fin >> dummyF; 

    //
    //    read in the next 127 numbers as the pedestals
    //
    for (Int_t i = 0; i<127; i++)
    {
        fin >> dummyF;

        if (dummyF > 0.0)
            fPedest[i] = dummyF;
    }

    fin >> dummyI;
}
