/////////////////////////////////////////////////////////////////////////////
//                                                                         //
//   MMcPedestalCopy                                                       //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#include "MMcPedestalCopy.h"

#include "MParList.h"

#include "MLog.h"
#include "MLogManip.h"

#include "MPedestalCam.h"
#include "MMcFadcHeader.hxx"

ClassImp(MMcPedestalCopy)

MMcPedestalCopy::MMcPedestalCopy(const char *name, const char *title)
{
    *fName  = name  ? name  : "MMcPedestalCopy";
    *fTitle = title ? title : "Task to copy monte carlo pedestals into MPedestal Container";
}

Bool_t MMcPedestalCopy::PreProcess( MParList *pList )
{
    fMcPedestals = (MMcFadcHeader*)pList->FindObject("MMcFadcHeader");
    if (!fMcPedestals)
    {
        *fLog << dbginf << "MMcFadcHeader not found... aborting." << endl;
        return kFALSE;
    }

    fPedestals = (MPedestalCam*)pList->FindCreateObj("MPedestalCam");
    if (!fPedestals)
        return kFALSE;

    return kTRUE;
}

Bool_t MMcPedestalCopy::Process()
{
    fPedestals->InitSize(fMcPedestals->GetNumPixel());

    for (int i=0; i<MFADC_CHANNELS; i++)
    {
        MPedestalPix &pix = (*fPedestals)[i];

        pix.SetPedestal(fMcPedestals->GetPedestal(i), 0);
        pix.SetPedestalRms(fMcPedestals->GetPedestalRms(i), 0);
    }

    return kTRUE;
}

