#ifndef MHFADCCAM_H
#define MHFADCCAM_H

#ifndef MAGIC_H
#include "MAGIC.h"
#endif

#ifndef ROOT_TObjArray
#include <TObjArray.h>
#endif

#ifndef MPARCONTAINER_H
#include "MParContainer.h"
#endif
#ifndef MHFADCPIX_H
#include "MHFadcPix.h"
#endif

class TH1F;

class MHFadcCam : public MParContainer
{
private:
    TObjArray *fArray;	// List of Lo/Hi gain Histograms

public:
     MHFadcCam(const char *name=NULL, const char *title=NULL);
    ~MHFadcCam();

    void FillHi(UInt_t ipix, Byte_t data) { (*this)[ipix]->FillHi(data); }
    void FillLo(UInt_t ipix, Byte_t data) { (*this)[ipix]->FillLo(data); }

    //    void SaveHist(char *name);

    MHFadcPix *operator[](UInt_t i) { return (MHFadcPix*)(fArray->At(i)); }

    TH1F *GetHistHi(UInt_t i)  { return (*this)[i]->GetHistHi(); }
    TH1F *GetHistLo(UInt_t i)  { return (*this)[i]->GetHistLo(); }

    void DrawHi(UInt_t i) { GetHistHi(i)->Draw(); }
    void DrawLo(UInt_t i) { GetHistLo(i)->Draw(); }

    void Draw(UInt_t i) { (*this)[i]->Draw(); }

    Int_t GetEntries()
    {
        return fArray->GetEntries() ;
    }

    ClassDef(MHFadcCam, 1)	// list of Histograms with ADC spectra
};

#endif

