#ifndef MARS_MHSingleMuon
#define MARS_MHSingleMuon

#ifndef MARS_MH
#include "MH.h"
#endif
#ifndef ROOT_TH1
#include <TH1.h>
#endif

class MSignalCam;
class MMuonSearchPar;
class MMuonCalibPar;
class MMuonSetup;
class MGeomCam;

class MHSingleMuon : public MH
{
private:
    MSignalCam     *fSignalCam;     //!
    MMuonSearchPar *fMuonSearchPar; //!
    MGeomCam       *fGeomCam;       //!

    Double_t fMargin;               //!

    TH1F fHistPhi;   // Histogram of photon distribution along the arc.
    TH1F fHistWidth; // Histogram of radial photon distribution of the arc.

    Bool_t FindRangeAboveThreshold(const TH1F &h, Float_t thres, Int_t &first, Int_t &last) const;

public:
    MHSingleMuon(const char *name=NULL, const char *title=NULL);

    Bool_t SetupFill(const MParList *plist);
    Bool_t Fill(const MParContainer *par, const Stat_t w=1);

    Bool_t CalcPhi(Double_t, Double_t &, Double_t &) const;
    Bool_t CalcWidth(Double_t, Double_t &, Double_t &);

    const TH1F &GetHistPhi() const { return fHistPhi; }
    const TH1F &GetHistWidth() const { return fHistWidth; }

    ClassDef(MHSingleMuon, 1) // Histograms of new image parameters
};

#endif


