#include "MGeomCamCT1.h"


#include <math.h>     // floor
#include "TCanvas.h"

#include "MLog.h"

ClassImp(MGeomCamCT1)

MGeomCamCT1::MGeomCamCT1(const char *name) : MGeomCam(127, name, "Geometry information of CT1 camera")
{
    CreateCam();
} 

void MGeomCamCT1::Draw( Option_t * )
{ 
    TCanvas *can = new TCanvas("can", "Camera Geometry", 4 ) ;

    can->Range(-175, -175, 175, 175 ) ;

    MGeomCam::Draw();
} 

void MGeomCamCT1::CreateCam()
{
    //
    // fill the geometry class with the coordinates of the CT1 camera
    //
    *fLog << " Create CT1 geometry " << endl;

    //
    // this algorithm is from Martin Kestel originally
    // it was punt into a root/C++ context by Harald Kornmayer and Thomas Bretz
   
    const Float_t diameter = 21 ;    // units are mm
    const Float_t kS32  = sqrt(3)/2;

    //
    //  add the first pixel to the list
    //
    Int_t pixnum = 0;

    (*this)[pixnum++].Set(0, 0, diameter);

    for (Int_t ring=1; ring<7; ring++)
    {
        //
        // calc. coords for this ring counting from the
        // starting number to the ending number
        //
        for (int i=0; i<ring; i++)
            (*this)[pixnum++].Set((-ring+i*0.5)*diameter,
                                  i*kS32*diameter,
                                  diameter);

        for (int i=0; i<ring; i++)
            (*this)[pixnum++].Set((-ring*0.5+i)*diameter,
                                  ring*kS32 * diameter,
                                  diameter);

        for (int i=0; i<ring; i++)
            (*this)[pixnum++].Set((ring+i)*0.5*diameter,
                                  (ring-i)*kS32*diameter,
                                  diameter);

        for (int i=0; i<ring; i++)
            (*this)[pixnum++].Set((ring-0.5*i)*diameter,
                                  -i*kS32*diameter,
                                  diameter);

        for (int i=0; i<ring; i++)
            (*this)[pixnum++].Set((ring*0.5-i)*diameter,
                                  -ring*kS32 * diameter,
                                  diameter);

        cout << pixnum << " " << ring << endl;

        for (int i=0; i<ring; i++)
            (*this)[pixnum++].Set((-ring-i)*0.5*diameter,
                                  (-ring+i)*kS32*diameter,
                                  diameter);
    }
}

