#ifndef MARS_MHWeather
#define MARS_MHWeather

#ifndef MARS_MH
#include "MH.h"
#endif
#ifndef ROOT_TGraph
#include <TGraph.h>
#endif

class MReportCC;
class MEventRate;

class MHWeather : public MH
{
private:
    TGraph fHumidity;        // 
    TGraph fTemperature;     //
    TGraph fWindSpeed;       //
    TGraph fSolarRadiation;  //
    TGraph fEventRate;       //!

    MReportCC  *fReport;     //!
    MEventRate *fRate;       //!

    void ResetGraph(TGraph &g) const;
    void InitGraph(TGraph &g) const;
    void AddPoint(TGraph &g, Double_t x, Double_t y) const;
    void DrawGraph(TGraph &g, const char *y=0) const;
    void UpdateRightAxis(TGraph &g) const;
    void DrawRightAxis(const char *title) const;

public:
    MHWeather(const char *name=NULL, const char *title=NULL);

    Bool_t SetupFill(const MParList *plist);
    Bool_t Fill(const MParContainer *par, const Stat_t w=1);

    void Draw(Option_t *opt="");
    void Paint(Option_t *opt="");

    ClassDef(MHWeather, 1) // Histogram to display weather data
};

#endif


