void readMagic()
{
    MParList plist;

    MGeomCamMagic geomcam;
    MPedestalCam  pedest;
    MHillas       hillas;
    MTaskList     tlist;

    plist->AddToList(&geomcam);
    plist->AddToList(&pedest);
    plist->AddToList(&hillas);
    plist->AddToList(&tlist);

    MReadTree    read("Events", "oscar_protons.root");
    MReadTree    read.AddFile("test.root");
    MCerPhotCalc ncalc;
    MImgCleanStd clean;
    MHillasCalc  hcalc;

    tlist.AddToList(&read);
    tlist.AddToList(&ncalc);
    tlist.AddToList(&clean);
    tlist.AddToList(&hcalc);

    MEvtLoop evtloop;
    evtloop.SetParList(&plist);

    if (!evtloop.PreProcess())
        return;

    MCerPhotEvt &phevt = *(MCerPhotEvt*)plist->FindObject("MCerPhotEvt");

    Int_t icount = 0 ;
    MCamDisplay display(&geomcam) ;

    while (read.Process())
    {
        cout << "Event: " << icount++  << endl  ;

        ncalc.Process();

        display.DrawPhotNum(&phevt);
        gClient->HandleInput();
        if(getchar()=='q')
            break;

        clean.Process();
        hcalc.Process();

        hillas.Print();
        hillas.Draw();

        display.DrawPhotNum(&phevt);

        gClient->HandleInput();
        if(getchar()=='q')
            break;

        hillas.Clear();
    } 

    evtloop.PostProcess();
}
