/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MCT1ReadAscii                                                           //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#include "MCT1ReadAscii.h"

#include <fstream.h>

#include "MLog.h"
#include "MLogManip.h"

#include "MParList.h"
#include "MCerPhotEvt.h"
#include "MPedestalCam.h"

ClassImp(MCT1ReadAscii)

MCT1ReadAscii::MCT1ReadAscii(const char *fname,
			     const char *name, 
			     const char *title)
{
    *fName  = name  ? name  : "MCT1ReadAscii";
    *fTitle = title ? title : "Task to loop over events in CT1 ascii file";

    //
    // remember file name for opening the file in the preprocessor
    //
    fFileName = fname;
}

Bool_t MCT1ReadAscii::PreProcess(MParList *pList)
{
    //
    // Preprocessing
    //

    //
    // open the input stream and check if it is really open (file exists?)
    //
    fIn = new ifstream(fFileName);
    if (!(*fIn))
    {
        *fLog << dbginf << "Cannot open file." << endl;
        return kFALSE;
    }

    //
    //  look for the MCerPhotEvt class in the plist
    //
    fNphot = (MCerPhotEvt*)pList->FindCreateObj("MCerPhotEvt");
    if (!fNphot)
        return kFALSE;

    //
    //  look for the pedestal class in the plist
    //
    fPedest = (MPedestalCam*)pList->FindCreateObj("MPedestalCam");
    if (!fPedest)
        return kFALSE;

    fPedest->InitSize(127);

    return kTRUE;
}

void MCT1ReadAscii::ReadPedestals()
{
    *fLog << "MCT1Pedestals::AsciiRead: Reading Pedestals..." << endl;

    //
    // skip the next 4 values
    //
    Float_t val;

    *fIn >> val;
    *fIn >> val;
    *fIn >> val;
    *fIn >> val;

    //
    //    read in the next 127 numbers as the pedestals
    //
    for (Int_t i = 0; i<127; i++)
    {
        *fIn >> val;

        if (val > 0.0)
            (*fPedest)[i].SetSigma(val);
    }
}

void MCT1ReadAscii::ReadData()
{
    //
    // clear the list of cerphot-events
    //
    fNphot->Clear();

    //
    // five unsused numbers
    //
    Int_t val;

    *fIn >> val;   // ener
    *fIn >> val;   // zenang
    *fIn >> val;   // sec1
    *fIn >> val;   // sec2

    //
    // read in the number of cerenkov photons and add the 'new' pixel
    // too the list with it's id, number of photons and error
    //
    for (Int_t i = 0; i<127; i++ )
    {
        Float_t nphot;

        *fIn >> nphot;

        if (nphot > 0.0)
            fNphot->AddPixel(i, nphot, (*fPedest)[i].GetSigma());
    }

}

Bool_t MCT1ReadAscii::Process()
{
    //
    // FIXME. This function should switch between reading pedestals and
    // reading event data by the 'switch entry'.
    // After reading it should set the InputStreamID correctly.
    // ( should use MPedestalCam )
    //
 
    //
    // read in the event nr
    //
    Int_t evtnr;
    *fIn >> evtnr;

    //
    // check if we are done
    //
    if (fIn->eof())
        return kFALSE;

    //
    // if the first number is negativ this is a pedestal line:
    // read in pedestals
    //
    // FIXME! Set InputStreamID

    if (evtnr < 0)
    {
        ReadPedestals();
        return kCONTINUE;
    }

    ReadData();

    return kTRUE;
}

Bool_t MCT1ReadAscii::PostProcess()
{
    //
    // close and delete the input stream
    //
    delete fIn;

    return kTRUE;
}

