/////////////////////////////////////////////////////////////////////////////
//                                                                         //
//   MHillas Calc                                                          //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#include "MHillasCalc.h"

#include "MParList.h"

#include "MHillas.h"
#include "MCerPhotEvt.h"

#include "MLog.h"
#include "MLogManip.h"

ClassImp(MHillasCalc)

MHillasCalc::MHillasCalc(const char *name, const char *title)
{
    *fName  = name  ? name  : "MHillasCalc";
    *fTitle = title ? title : "Task to calculate Hillas parameters";
}

Bool_t MHillasCalc::PreProcess( MParList *pList )
{
    fCerPhotEvt = (MCerPhotEvt*)pList->FindObject("MCerPhotEvt");
    if (!fCerPhotEvt)
    {
        *fLog << dbginf << "MCerPhotEvt not found... aborting." << endl;
        return kFALSE;
    }

    fGeomCam = (MGeomCam*)pList->FindObject("MGeomCam");
    if (!fGeomCam)
    {
        *fLog << dbginf << "MGeomCam (Camera Geometry) missing in Parameter List... aborting." << endl;
        return kFALSE;
    }

    fHillas = (MHillas*)pList->FindCreateObj("MHillas");
    if (!fHillas)
        return kFALSE;

    return kTRUE;
}

Bool_t MHillasCalc::Process()
{
    //
    // If you want do complex descisions inside the calculations
    // we must move the calculation code inside this function
    //
    // If the calculation wasn't sucessfull skip this event
    //
    return fHillas->Calc(*fGeomCam, *fCerPhotEvt) ? kTRUE : kCONTINUE;
}

