#include "MCollAreaTrigger.h"

#include "MLog.h"
#include "MLogManip.h"
#include "MParList.h"

#include "MCollArea.h"
#include "MMcEvt.hxx" 
#include "MMcTrig.hxx" 

ClassImp(MCollAreaTrigger)

MCollAreaTrigger::MCollAreaTrigger (const char *name, const char *title)
{
  *fName  = name  ? name  : "MCollAreaTrigger";
  *fTitle = title ? title : "Task to calc the collection area ";
} 


Bool_t MCollAreaTrigger::PreProcess (MParList *pList)
{
  // connect the raw data with this task
  
  fMcEvt  = (MMcEvt*)pList->FindCreateObj("MMcEvt") ; 
  if (!fMcEvt)
    return kFALSE;

  fMcTrig = (MMcTrig*)pList->FindCreateObj("MMcTrig") ; 
  if (!fMcTrig) 
    return kFALSE;

  fCollArea = (MCollArea*)pList->FindCreateObj("MCollArea") ; 
  if (!fCollArea) 
    return kFALSE;

  return kTRUE ; 

} 


Bool_t MCollAreaTrigger::Process () 
{ 

  fCollArea->FillAll( log10( fMcEvt->GetEnergy()) , 
			     fMcEvt->GetImpact()/100. ) ; 
  
  if ( fMcTrig->GetFirstLevel() > 0 ) 
    fCollArea->FillSel( log10( fMcEvt->GetEnergy()) , 
			fMcEvt->GetImpact()/100. ) ; 
  
  return kTRUE ; 
} 

Bool_t MCollAreaTrigger::PostProcess () 
{ 
  // 
  //   do the calculation of the effectiv area
  //

  fCollArea->CalculateEffi() ; 

  return kTRUE ; 
}
