#include "MCollAreaTrigger.h"

#include "MLog.h"
#include "MLogManip.h"
#include "MParList.h"

#include "MCollArea.h"
#include "MMcEvt.hxx" 
#include "MMcTrig.hxx" 

ClassImp(MCollAreaTrigger)

MCollAreaTrigger::MCollAreaTrigger (const char *name, const char *title)
{
  *fName  = name  ? name  : "MCollAreaTrigger";
  *fTitle = title ? title : "Task to calc the collection area ";
} 


Bool_t MCollAreaTrigger::PreProcess (MParList *pList)
{
  // connect the raw data with this task
  
  fMcEvt  = (MMcEvt*)pList->FindObject("MMcEvt") ;
  if (!fMcEvt) { 
    *fLog << dbginf << "MMcEvt not found... exit." << endl;
    return kFALSE;
  } 

  fMcTrig = (MMcTrig*)pList->FindObject("MMcTrig") ;
  if (!fMcTrig) { 
    *fLog << dbginf << "MMcTrig not found... exit." << endl;
    return kFALSE;
  } 

  fCollArea = (MCollArea*)pList->FindCreateObj("MCollArea") ; 
  if (!fCollArea)
    return kFALSE;

  return kTRUE ; 

} 


Bool_t MCollAreaTrigger::Process () 
{ 
    const Float_t energy = log10(fMcEvt->GetEnergy());
    const Float_t impact = fMcEvt->GetImpact()/100.;

    fCollArea->FillAll(energy, impact);


    if (fMcTrig->GetFirstLevel() <= 0)
        return kTRUE;

    fCollArea->FillSel(energy, impact);

    return kTRUE ;
}

Bool_t MCollAreaTrigger::PostProcess () 
{ 
  // 
  //   do the calculation of the effectiv area
  //

  fCollArea->CalculateEffi() ; 

  return kTRUE ; 
}
