void readCT1()
{
    MParList plist;

    MGeomCamCT1 geomcam;
    MHillas     hillas;
    MTaskList   tlist;

    plist->AddToList(&geomcam);
    plist->AddToList(&hillas);
    plist->AddToList(&tlist);

    MCT1ReadAscii read("CT1_99_off1.dat") ;
    MImgCleanStd  clean;
    MHillasCalc   hcalc;

    tlist.AddToList(&read);
    tlist.AddToList(&clean);
    tlist.AddToList(&hcalc);

    MEvtLoop evtloop;
    evtloop.SetParList(&plist);

    if (!evtloop.PreProcess())
        return;

    MCerPhotEvt &phevt = *(MCerPhotEvt*)plist->FindObject("MCerPhotEvt");

    Int_t icount = 0 ;
    MCamDisplay display(&geomcam) ;
        display.DrawPhotNum(&phevt);


    while (read.Process())
    {
        cout << "Event: " << icount++  << endl  ;

        display.DrawPhotNum(&phevt);
        gClient->HandleInput();
        if(getchar()=='q')
            break;

        clean.Process();
        hcalc.Process();

        hillas.Print();
        hillas.Draw();

        display.DrawPhotNum(&phevt);

        gClient->HandleInput();
        if(getchar()=='q')
            break;

        hillas.Clear();
    } 

    evtloop.PostProcess();
}
