#include "MFillHStarMap.h"

#include "MLog.h"
#include "MLogManip.h"
#include "MHStarMap.h"
#include "MHillas.h"
#include "MParList.h"

ClassImp(MFillHStarMap)

MFillHStarMap::MFillHStarMap (const char *name, const char *title)
{
    *fName  = name  ? name  : "MFillHStarMap";
    *fTitle = title ? title : "Task to fill a StarMap";
}

Bool_t MFillHStarMap::PreProcess (MParList *pList)
{
    fEvt = (MHillas*)pList->FindObject("MHillas");
    if (!fEvt)
    {
        *fLog << dbginf << "MHillas not found... aborting." << endl;
        return kFALSE ;
    }

    fHistos = (MHStarMap*)pList->FindCreateObj("MHStarMap");
    if (!fHistos)
        return kFALSE;

    return kTRUE ;
} 

Bool_t MFillHStarMap::Process()
{
//    if (fabs(fEvt->GetAlpha())>60)
//        return kCONTINUE;

    fHistos->Fill(fEvt);

    return kTRUE;
} 
