#include "MFillHFadc.h"

#include "MLog.h"
#include "MLogManip.h"
#include "MParList.h"
#include "MHFadcCam.h"
#include "MRawEvtData.h"
#include "MRawEvtPixelIter.h"

ClassImp(MFillHFadc)

    MFillHFadc::MFillHFadc (const char *name, const char *title) : fRawEvtData(NULL)
{
  *fName  = name  ? name  : "MFillHFadc";
  *fTitle = title ? title : "Task to fill the adc spectra with  raw data";
}

Bool_t MFillHFadc::PreProcess (MParList *pList)
{
  // connect the raw data with this task
  
  fHistos = (MHFadcCam*)pList->FindCreateObj("MHFadcCam");
  if (!fHistos)
      return kFALSE;

  fRawEvtData = (MRawEvtData*)pList->FindCreateObj("MRawEvtData");
  if (!fRawEvtData)
  {
      *fLog << dbginf << " Error: MRawEvtData not found... exit." << endl;
      return kFALSE ;
  }

  return kTRUE ; 

} 

Bool_t MFillHFadc::Process()
{
  //  loop over the pixels and fill the values in the histograms
  
  MRawEvtPixelIter pixel(fRawEvtData);

  const Int_t nhisamples = fRawEvtData->GetNumHiGainSamples() ;
  const Int_t nlosamples = fRawEvtData->GetNumLoGainSamples() ;

  //  cout << "HighSamples " << iHighSamples ;

  while ( pixel.Next() )
    { 
      for (Int_t i=0 ; i<nhisamples ; i++ )
	{ 
            fHistos->FillHi ( pixel.GetPixelId(),
                              pixel.GetHiGainFadcSamples()[i] );
	}

      for (Int_t i=0 ; i<nlosamples ; i++ )
	{ 
            fHistos->FillLo ( pixel.GetPixelId(),
                              pixel.GetLoGainFadcSamples()[i] );
	}
    } 
  
  return kTRUE;
  
} 
