#include "MFillHHillas.h"

#include "MLog.h"
#include "MLogManip.h"
#include "MHHillas.h"
#include "MParList.h"

ClassImp(MFillHHillas)

MFillHHillas::MFillHHillas (const char *name, const char *title)
{
    *fName  = name  ? name  : "MFillHHillas";
    *fTitle = title ? title : "Task to fill Hillas histograms";
}

Bool_t MFillHHillas::PreProcess (MParList *pList)
{
    fEvt = (MHillas*)pList->FindObject("MHillas");
    if (!fEvt)
    {
        *fLog << dbginf << "MHillas not found... aborting." << endl;
        return kFALSE ;
    }

    fHistos = (MHHillas*)pList->FindCreateObj("MHHillas");
    if (!fHistos)
        return kFALSE;

    return kTRUE ;
} 

Bool_t MFillHHillas::Process()
{
    fHistos->Fill(fEvt);

    return kTRUE;
} 
